/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.operators.SetSelf;
import org.quattor.pan.dml.operators.Variable;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Term;
import org.quattor.pan.utils.TermFactory;

public class SetValue
extends AbstractOperation {
    private static final String[] automaticVariables = new String[]{"OBJECT", "FUNCTION", "TEMPLATE"};
    protected String identifier;

    protected SetValue(SourceRange sourceRange, String identifier, Operation ... operations) throws SyntaxException {
        super(sourceRange, operations);
        assert (identifier != null);
        this.identifier = identifier;
        this.validName(identifier);
        SetValue.checkStaticIndexes(sourceRange, operations);
    }

    protected static void checkStaticIndexes(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        for (int i = 0; i < operations.length; ++i) {
            if (!(operations[i] instanceof Element)) continue;
            try {
                TermFactory.create((Element)operations[i]);
                continue;
            }
            catch (EvaluationException ee) {
                throw SyntaxException.create(sourceRange, "MSG_INVALID_TERM", i);
            }
        }
    }

    protected void validName(String name) throws SyntaxException {
        for (String varName : automaticVariables) {
            if (!varName.equals(name)) continue;
            throw SyntaxException.create(this.getSourceRange(), "MSG_AUTO_VAR_CANNOT_BE_SET", varName);
        }
    }

    public static SetValue getInstance(SourceRange sourceRange, String identifier, Operation ... operations) throws SyntaxException {
        return SetValue.createSubclass(sourceRange, identifier, operations);
    }

    public static SetValue getInstance(Variable v) throws SyntaxException {
        SourceRange sourceRange = v.getSourceRange();
        String identifier = v.identifier;
        Operation[] operations = v.getOperations();
        return SetValue.createSubclass(sourceRange, identifier, operations);
    }

    private static SetValue createSubclass(SourceRange sourceRange, String identifier, Operation ... operations) throws SyntaxException {
        SetValue result = "SELF".equals(identifier) ? new SetSelf(sourceRange, operations) : new SetValue(sourceRange, identifier, operations);
        return result;
    }

    public Element execute(Context context) {
        throw CompilerError.create("MSG_INVALID_EXECUTE_METHOD_CALLED", "SetValue");
    }

    public Element execute(Context context, Element result) {
        Term[] terms = null;
        try {
            terms = this.calculateTerms(context);
        }
        catch (EvaluationException e) {
            throw e.addExceptionInfo(this.sourceRange, context);
        }
        Element dupResult = result;
        if (result != null && (terms.length > 0 || result.isProtected())) {
            dupResult = result.duplicate();
        }
        try {
            context.setLocalVariable(this.identifier, terms, dupResult);
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.sourceRange, context);
        }
        return dupResult;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.identifier + "," + this.ops.length + ")";
    }
}

