/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.parser;

import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.parser.PanParser;
import org.quattor.pan.parser.SimpleNode;
import org.quattor.pan.utils.Path;
import org.quattor.pan.utils.Term;

public class ASTFieldSpec
extends SimpleNode {
    private boolean required = false;
    private String path = null;
    private String include = null;

    public ASTFieldSpec(int id) {
        super(id);
    }

    public ASTFieldSpec(PanParser p, int id) {
        super(p, id);
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Term getKey() throws SyntaxException {
        Term t = null;
        try {
            Path p = new Path(this.path);
            Term[] terms = p.getTerms();
            if (terms.length != 1) {
                throw SyntaxException.create(this.getSourceRange(), "MSG_FIELD_MUST_BE_VALID_TERM", this.path);
            }
            t = terms[0];
            if (!t.isKey()) {
                throw SyntaxException.create(this.getSourceRange(), "MSG_FIELD_MUST_BE_VALID_KEY", this.path);
            }
        }
        catch (EvaluationException ee) {
            throw SyntaxException.create(this.getSourceRange(), "MSG_FIELD_MUST_BE_VALID_PATH", this.path);
        }
        catch (SyntaxException se) {
            throw se.addExceptionInfo(this.getSourceRange(), null);
        }
        return t;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getInclude() {
        return this.include;
    }

    public String toString() {
        String s = "";
        if (this.include != null) {
            s = s + "include " + this.include;
        } else {
            s = s + this.path;
            s = this.required ? s + " : " : s + " ? ";
        }
        return s;
    }
}

