/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.repository;

import java.io.File;
import java.util.List;
import org.quattor.pan.repository.FileSystemSourceRepository;
import org.quattor.pan.utils.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemSourceRepositoryWithoutSessionDir
extends FileSystemSourceRepository {
    private final List<File> includeDirectories;

    public FileSystemSourceRepositoryWithoutSessionDir(List<File> includeDirectories) {
        this.includeDirectories = this.validateAndCopyIncludeDirectories(includeDirectories);
    }

    @Override
    public File lookupText(String name) {
        return this.lookupText(name, emptyRelativePaths);
    }

    @Override
    public File lookupText(String name, List<String> loadpath) {
        assert (name != null);
        assert (loadpath != null);
        assert (loadpath.size() > 0);
        String localName = FileUtils.localizeFilename(name);
        for (File d : this.includeDirectories) {
            for (String rpath : loadpath) {
                File dir = new File(d, rpath);
                File sourceFile = new File(dir, localName);
                if (!sourceFile.exists()) continue;
                return sourceFile;
            }
        }
        return null;
    }

    @Override
    public File lookupSource(String name) {
        return this.lookupSource(name, emptyRelativePaths);
    }

    @Override
    public File lookupSource(String name, List<String> loadpath) {
        assert (name != null);
        assert (loadpath != null);
        assert (loadpath.size() > 0);
        String localName = FileUtils.localizeFilename(name);
        for (File d : this.includeDirectories) {
            for (String rpath : loadpath) {
                File dir = new File(d, rpath);
                for (String suffix : sourceFileExtensions) {
                    File sourceFile = new File(dir, localName + suffix);
                    if (!sourceFile.exists()) continue;
                    return sourceFile;
                }
            }
        }
        return null;
    }
}

