/*
 Copyright (c) 2006 Charles A. Loomis, Jr, Cedric Duprilot, and
 Centre National de la Recherche Scientifique (CNRS).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 $HeadURL: https://svn.lal.in2p3.fr/LCG/QWG/panc/trunk/src/org/quattor/pan/parser/SimpleNode.java $
 $Id: SimpleNode.java 3515 2008-07-31 13:20:05Z loomis $
 */

package org.quattor.pan.parser;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.quattor.pan.template.SourceRange;

public class SimpleNode implements Node {
	protected Node parent;
	protected Node[] children;
	protected int id;
	protected PanParser parser;

	private SourceRange sourceRange = null;

	protected List<Token> specialTokens = new LinkedList<Token>();

	public SimpleNode(int i) {
		id = i;
	}

	public SimpleNode(PanParser p, int i) {
		this(i);
		parser = p;
	}

	public void jjtOpen() {
	}

	public void jjtClose() {
	}

	public void jjtSetParent(Node n) {
		parent = n;
	}

	public Node jjtGetParent() {
		return parent;
	}

	public void jjtAddChild(Node n, int i) {
		if (children == null) {
			children = new Node[i + 1];
		} else if (i >= children.length) {
			Node c[] = new Node[i + 1];
			System.arraycopy(children, 0, c, 0, children.length);
			children = c;
		}
		children[i] = n;
	}

	public Node jjtGetChild(int i) {
		return children[i];
	}

	public int jjtGetNumChildren() {
		return (children == null) ? 0 : children.length;
	}

	/*
	 * You can override these two methods in subclasses of SimpleNode to
	 * customize the way the node appears when the tree is dumped. If your
	 * output uses more than one line you should override toString(String),
	 * otherwise overriding toString() is probably all you need to do.
	 */

	@Override
	public String toString() {
		return PanParserTreeConstants.jjtNodeName[id];
	}

	public String toString(String prefix) {
		return prefix + toString();
	}

	/*
	 * Override this method if you want to customize how the node dumps out its
	 * children.
	 */

	public void dump(String prefix) {
		System.out.println(toString(prefix));
		if (children != null) {
			for (int i = 0; i < children.length; ++i) {
				SimpleNode n = (SimpleNode) children[i];
				if (n != null) {
					n.dump(prefix + " ");
				}
			}
		}
	}

	public void setSourceRange(SourceRange sourceRange) {
		this.sourceRange = sourceRange;
	}

	public SourceRange getSourceRange() {
		return (sourceRange);
	}

	public int getId() {
		return id;
	}

	public void addSpecialToken(Token specialToken) {
		specialTokens.add(specialToken);
	}

	public List<Token> getSpecialTokens() {
		return Collections.unmodifiableList(specialTokens);
	}

}
