/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan;

import java.io.File;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.HashResource;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.ConfigurationException;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.parser.ASTOperation;
import org.quattor.pan.parser.PanParser;
import org.quattor.pan.parser.PanParserAstUtils;
import org.quattor.pan.repository.ParameterList;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.repository.SourceRepository;
import org.quattor.pan.repository.SourceRepositoryFactory;
import org.quattor.pan.template.CompileTimeContext;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerOptions {
    public final boolean xmlWriteEnabled;
    public final boolean depWriteEnabled;
    public final boolean forceBuild;
    public final int iterationLimit;
    public final int callDepthLimit;
    public final Formatter formatter;
    public final File outputDirectory;
    public final int activeThreadsPerQueue;
    public final boolean gzipOutput;
    public final int deprecationLevel;
    public final boolean failOnWarn;
    public final SourceRepository sourceRepository;
    private final List<Pattern> debugIncludePatterns;
    private final List<Pattern> debugExcludePatterns;
    public final File annotationDirectory;
    public final File annotationBaseDirectory;
    public final HashResource rootElement;

    public CompilerOptions(List<Pattern> debugIncludePatterns, List<Pattern> debugExcludePatterns, boolean xmlWriteEnabled, boolean depWriteEnabled, int iterationLimit, int callDepthLimit, Formatter formatter, File outputDirectory, File sessionDirectory, List<File> includeDirectories, int nthread, boolean gzipOutput, int deprecationLevel, boolean forceBuild, File annotationDirectory, File annotationBaseDirectory, boolean failOnWarn, String rootElement) throws SyntaxException {
        if (iterationLimit <= 0) {
            iterationLimit = Integer.MAX_VALUE;
        }
        if (callDepthLimit <= 0) {
            callDepthLimit = Integer.MAX_VALUE;
        }
        if (outputDirectory != null) {
            this.checkDirectory(outputDirectory, "output");
        }
        if (sessionDirectory != null) {
            this.checkDirectory(sessionDirectory, "session");
        }
        for (File d : includeDirectories) {
            if (d != null) {
                this.checkDirectory(d, "include");
                continue;
            }
            throw new IllegalArgumentException("include directory may not be null");
        }
        if (outputDirectory == null && (xmlWriteEnabled || depWriteEnabled)) {
            throw new IllegalArgumentException("outputDirectory must be specified if the XML or dependency files are to be written");
        }
        if (formatter == null && xmlWriteEnabled) {
            throw new IllegalArgumentException("formatter must be specified if XML file is to be written");
        }
        this.xmlWriteEnabled = xmlWriteEnabled;
        this.depWriteEnabled = depWriteEnabled;
        this.iterationLimit = iterationLimit;
        this.callDepthLimit = callDepthLimit;
        this.formatter = formatter;
        this.outputDirectory = outputDirectory;
        this.activeThreadsPerQueue = nthread;
        this.gzipOutput = gzipOutput;
        this.deprecationLevel = deprecationLevel;
        this.failOnWarn = failOnWarn;
        this.forceBuild = forceBuild;
        this.debugIncludePatterns = debugIncludePatterns == null ? new LinkedList<Pattern>() : debugIncludePatterns;
        this.debugExcludePatterns = debugExcludePatterns == null ? new LinkedList<Pattern>() : debugExcludePatterns;
        ParameterList parameters = new ParameterList();
        if (sessionDirectory != null) {
            parameters.append("sessionDirectory", sessionDirectory.toString());
        }
        for (File f : includeDirectories) {
            parameters.append("includeDirectory", f.toString());
        }
        SourceRepository value = null;
        try {
            value = SourceRepositoryFactory.create(parameters);
        }
        catch (ConfigurationException ce) {
            throw new RuntimeException(ce.getMessage());
        }
        this.sourceRepository = value;
        this.annotationDirectory = annotationDirectory;
        if (annotationDirectory != null) {
            this.checkDirectory(annotationDirectory, "annotation");
        }
        this.annotationBaseDirectory = annotationBaseDirectory;
        if (annotationBaseDirectory != null) {
            this.checkDirectory(annotationBaseDirectory, "annotation base");
        }
        this.rootElement = CompilerOptions.createRootElement(rootElement);
    }

    public static CompilerOptions createCheckSyntaxOptions(int deprecationLevel, boolean failOnWarn) {
        LinkedList<Pattern> debugIncludePatterns = new LinkedList<Pattern>();
        LinkedList<Pattern> debugExcludePatterns = new LinkedList<Pattern>();
        boolean xmlWriteEnabled = false;
        boolean depWriteEnabled = false;
        int iterationLimit = 5000;
        int callDepthLimit = 50;
        Formatter formatter = null;
        File outputDirectory = null;
        File sessionDirectory = null;
        int nthread = 0;
        boolean gzipOutput = false;
        boolean forceBuild = false;
        File annotationDirectory = null;
        File annotationBaseDirectory = null;
        LinkedList<File> includeDirectories = new LinkedList<File>();
        try {
            return new CompilerOptions(debugIncludePatterns, debugExcludePatterns, xmlWriteEnabled, depWriteEnabled, iterationLimit, callDepthLimit, formatter, outputDirectory, sessionDirectory, includeDirectories, nthread, gzipOutput, deprecationLevel, forceBuild, annotationDirectory, annotationBaseDirectory, failOnWarn, null);
        }
        catch (SyntaxException consumed) {
            throw CompilerError.create("MSG_FILE_BUG_REPORT", new Object[0]);
        }
    }

    public static HashResource createRootElement(String rootElement) throws SyntaxException {
        if (rootElement == null || "".equals(rootElement.trim())) {
            return new HashResource();
        }
        try {
            PanParser parser = new PanParser(new StringReader(rootElement));
            ASTOperation ast = parser.dml();
            Operation dml = PanParserAstUtils.astToDml(ast);
            return (HashResource)dml.execute(new CompileTimeContext());
        }
        catch (SyntaxException e) {
            throw SyntaxException.create(null, "MSG_INVALID_SYNTAX_ROOT_ELEMENT", e.getMessage());
        }
        catch (ClassCastException e) {
            throw SyntaxException.create(null, "MSG_INVALID_TYPE_FOR_ROOT_ELEMENT", new Object[0]);
        }
    }

    private void checkDirectory(File d, String dtype) {
        if (!d.isAbsolute()) {
            throw new IllegalArgumentException(dtype + " directory must be an absolute path");
        }
        if (!d.exists()) {
            throw new IllegalArgumentException(dtype + " directory does not exist");
        }
        if (!d.isDirectory()) {
            throw new IllegalArgumentException(dtype + " directory value is not a directory");
        }
    }

    public Set<File> resolveFileList(List<String> objectNames, Collection<File> tplFiles) {
        TreeSet<File> filesToProcess = new TreeSet<File>();
        if (tplFiles != null) {
            filesToProcess.addAll(tplFiles);
        }
        if (objectNames != null) {
            for (String oname : objectNames) {
                SourceFile source = this.sourceRepository.retrievePanSource(oname);
                if (!source.isAbsent()) {
                    filesToProcess.add(source.getPath());
                    continue;
                }
                throw EvaluationException.create((SourceRange)null, (Context)null, "MSG_CANNOT_LOCATE_OBJECT_TEMPLATE", oname);
            }
        }
        return Collections.unmodifiableSet(filesToProcess);
    }

    public boolean checkDebugEnabled(String tplName) {
        for (Pattern p : this.debugExcludePatterns) {
            if (!p.matcher(tplName).matches()) continue;
            return false;
        }
        for (Pattern p : this.debugIncludePatterns) {
            if (!p.matcher(tplName).matches()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("debug include patterns: ");
        for (Pattern p : this.debugIncludePatterns) {
            sb.append(p.toString());
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("debug exclude patterns: ");
        for (Pattern p : this.debugExcludePatterns) {
            sb.append(p.toString());
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("XML write enabled: ");
        sb.append(this.xmlWriteEnabled);
        sb.append("\n");
        sb.append("dependency write enabled: ");
        sb.append(this.depWriteEnabled);
        sb.append("\n");
        sb.append("iteration limit: ");
        sb.append(this.iterationLimit);
        sb.append("\n");
        sb.append("call depth limit: ");
        sb.append(this.callDepthLimit);
        sb.append("\n");
        sb.append("gzip output: ");
        sb.append(this.gzipOutput);
        sb.append("\n");
        sb.append("output directory: ");
        sb.append(this.outputDirectory);
        sb.append("\n");
        if (this.formatter != null) {
            sb.append("formatter: ");
            sb.append(this.formatter.getClass().toString());
            sb.append("\n");
        } else {
            sb.append("formatter: null\n");
        }
        sb.append("source repository: ");
        sb.append(this.sourceRepository.toString());
        sb.append("\n");
        return sb.toString();
    }
}

