/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.quattor.pan.CompilerStatistics;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.SystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerResults {
    private CompilerStatistics stats;
    private Set<Throwable> errors;

    public CompilerResults(CompilerStatistics stats, Set<Throwable> errors) {
        this.stats = stats;
        if (stats == null) {
            throw new IllegalArgumentException("compiler statistics may not be null");
        }
        this.errors = Collections.unmodifiableSet(errors);
        if (errors == null) {
            this.errors = new TreeSet<Throwable>();
        }
    }

    public boolean print(boolean verbose) {
        String errors = this.formatErrors();
        if (errors != null) {
            System.err.println(errors);
        }
        if (verbose) {
            System.out.println(this.formatStats());
        }
        return errors != null;
    }

    public String formatErrors() {
        if (this.errors.size() > 0) {
            StringBuilder results = new StringBuilder();
            for (Throwable t : this.errors) {
                results.append(t.getMessage());
                results.append("\n");
                if (t instanceof NullPointerException || t instanceof CompilerError) {
                    results.append(this.formatStackTrace(t));
                    continue;
                }
                if (!(t instanceof SystemException)) continue;
                results.append(this.formatStackTrace(t));
                Throwable cause = t.getCause();
                if (cause != null) {
                    results.append("\nCause:\n");
                    results.append(cause.getMessage());
                    results.append("\n");
                }
                results.append(this.formatStackTrace(t));
            }
            return results.toString();
        }
        return null;
    }

    private String formatStackTrace(Throwable t) {
        StringBuilder trace = new StringBuilder("");
        for (StackTraceElement element : t.getStackTrace()) {
            trace.append(element.toString());
            trace.append("\n");
        }
        return trace.toString();
    }

    public String formatStats() {
        return this.stats.getResults(this.errors.size());
    }

    public Set<Throwable> getErrors() {
        return this.errors;
    }
}

