/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.CompilerOptions;
import org.quattor.pan.CompilerResults;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.output.FormatterUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Panc {
    private static Pattern debugAllPattern = Pattern.compile(".*");

    private Panc() {
    }

    public static void main(String[] args) {
        Vector<String> authorizedOpt = new Vector<String>();
        Vector<String> authorizedOptArg = new Vector<String>();
        Vector<String> endingOptChar = new Vector<String>();
        Vector<String> options = new Vector<String>();
        Vector<String> arguments = new Vector<String>();
        Vector<String> paths = new Vector<String>();
        String optbforname = null;
        authorizedOpt.addElement("help");
        authorizedOpt.addElement("usage");
        authorizedOpt.addElement("debug");
        authorizedOpt.addElement("debug-include");
        authorizedOptArg.addElement("debug-include");
        authorizedOpt.addElement("debug-exclude");
        authorizedOptArg.addElement("debug-exclude");
        authorizedOpt.addElement("root-element");
        authorizedOptArg.addElement("root-element");
        authorizedOpt.addElement("xml-write");
        authorizedOpt.addElement("no-xml-write");
        authorizedOpt.addElement("objects");
        authorizedOptArg.addElement("objects");
        authorizedOpt.addElement("objects-file");
        authorizedOptArg.addElement("objects-file");
        authorizedOpt.addElement("file");
        authorizedOptArg.addElement("file");
        authorizedOpt.addElement("check");
        authorizedOpt.addElement("session-dir");
        authorizedOptArg.addElement("session-dir");
        authorizedOpt.addElement("include-dir");
        authorizedOptArg.addElement("include-dir");
        authorizedOpt.addElement("output-dir");
        authorizedOptArg.addElement("output-dir");
        authorizedOpt.addElement("xml-style");
        authorizedOptArg.addElement("xml-style");
        authorizedOpt.addElement("dependency");
        authorizedOpt.addElement("max-iteration");
        authorizedOptArg.addElement("max-iteration");
        authorizedOpt.addElement("max-recursion");
        authorizedOptArg.addElement("max-recursion");
        authorizedOpt.addElement("gzip");
        authorizedOpt.addElement("deprecation");
        authorizedOptArg.addElement("deprecation");
        authorizedOpt.addElement("verbose");
        authorizedOpt.addElement("logging");
        authorizedOptArg.addElement("logging");
        authorizedOpt.addElement("logfile");
        authorizedOptArg.addElement("logfile");
        authorizedOpt.addElement("java-opts");
        authorizedOptArg.addElement("java-opts");
        authorizedOpt.addElement("annotation-dir");
        authorizedOptArg.addElement("annotation-dir");
        authorizedOpt.addElement("annotation-base-dir");
        authorizedOptArg.addElement("annotation-base-dir");
        authorizedOpt.addElement("failonwarn");
        endingOptChar.addElement("j");
        endingOptChar.addElement("J");
        endingOptChar.addElement("f");
        endingOptChar.addElement("S");
        endingOptChar.addElement("I");
        endingOptChar.addElement("O");
        endingOptChar.addElement("x");
        endingOptChar.addElement("i");
        endingOptChar.addElement("r");
        endingOptChar.addElement("p");
        TypeOptBfor optbfortype = TypeOptBfor.BEGIN;
        int nbofarg = 1;
        for (String arg : args) {
            boolean lastArg = false;
            if (nbofarg == args.length) {
                lastArg = true;
            }
            if (arg.startsWith("-") && arg.length() < 2) {
                Panc.catchError(1, arg);
                continue;
            }
            if (arg.startsWith("-") && arg.charAt(1) != '-' && optbfortype != TypeOptBfor.DMINUS && optbfortype != TypeOptBfor.DEPR) {
                if (optbfortype == TypeOptBfor.END) continue;
                if (optbfortype == TypeOptBfor.OPTARG) {
                    int numerror = Panc.calcNumError(optbforname);
                    Panc.catchError(numerror, arg);
                }
                if (optbfortype == TypeOptBfor.JOPT) {
                    optbfortype = TypeOptBfor.NOARG;
                    continue;
                }
                optbfortype = Panc.verifySingleCharOpt(arg, endingOptChar, lastArg);
                int rounds = optbfortype != TypeOptBfor.NOARG ? arg.length() - 1 : arg.length();
                for (int i = 1; i < rounds; ++i) {
                    options.addElement(arg.substring(i, i + 1));
                    arguments.addElement(null);
                }
                optbforname = arg.substring(arg.length() - 1);
                ++nbofarg;
                continue;
            }
            if (arg.startsWith("-") && arg.charAt(1) == '-' && optbfortype != TypeOptBfor.DMINUS) {
                if (optbfortype == TypeOptBfor.END) continue;
                if (optbfortype == TypeOptBfor.OPTARG) {
                    int numerror = Panc.calcNumError(optbforname);
                    Panc.catchError(numerror, arg);
                    continue;
                }
                if (arg.length() == 2) {
                    optbfortype = TypeOptBfor.DMINUS;
                    ++nbofarg;
                    continue;
                }
                optbfortype = Panc.verifyCompleteStringOpt(arg, authorizedOptArg, authorizedOpt, lastArg);
                if (optbfortype == TypeOptBfor.NOARG) {
                    options.addElement(arg.substring(2));
                    arguments.addElement(null);
                    optbforname = arg.substring(2);
                } else if (optbfortype == TypeOptBfor.OPTARG || optbfortype == TypeOptBfor.DEPR) {
                    optbforname = arg.substring(2);
                } else if (optbfortype != TypeOptBfor.JOPT) {
                    Pattern p = Pattern.compile("=");
                    String[] opts = p.split(arg, 2);
                    options.addElement(opts[0].substring(2));
                    arguments.addElement(opts[1]);
                    optbforname = opts[0].substring(2);
                }
                ++nbofarg;
                continue;
            }
            switch (optbfortype) {
                case JOPT: {
                    optbfortype = TypeOptBfor.NOARG;
                    break;
                }
                case END: {
                    paths.addElement(arg);
                    break;
                }
                case BEGIN: {
                    paths.addElement(arg);
                    optbfortype = TypeOptBfor.END;
                    break;
                }
                case NOARG: {
                    paths.addElement(arg);
                    optbfortype = TypeOptBfor.END;
                    break;
                }
                case OPTARG: {
                    if (Pattern.matches("[IjJf]", optbforname) || optbforname.equals("objects") || optbforname.equals("objects-file") || optbforname.equals("file") || optbforname.equals("include-dir")) {
                        if (nbofarg != args.length) {
                            options.addElement(optbforname);
                            arguments.addElement(arg);
                            optbfortype = TypeOptBfor.ARG;
                            break;
                        }
                        options.addElement(optbforname);
                        arguments.addElement(arg);
                        optbfortype = TypeOptBfor.END;
                        break;
                    }
                    options.addElement(optbforname);
                    arguments.addElement(arg);
                    optbfortype = TypeOptBfor.ARG;
                    break;
                }
                case ARG: {
                    paths.addElement(arg);
                    optbfortype = TypeOptBfor.END;
                    break;
                }
                case DMINUS: {
                    paths.addElement(arg);
                    optbfortype = TypeOptBfor.NOARG;
                    break;
                }
                case DEPR: {
                    if (nbofarg == args.length) {
                        System.exit(0);
                        break;
                    }
                    options.addElement(optbforname);
                    arguments.addElement(arg);
                    optbfortype = TypeOptBfor.ARG;
                }
            }
            ++nbofarg;
        }
        System.exit(Panc.launchCompiler(options, arguments, paths));
    }

    public static TypeOptBfor verifySingleCharOpt(String arg, Vector<String> endingOptChar, boolean lastArg) {
        TypeOptBfor type = TypeOptBfor.NOARG;
        if (arg.substring(1).equals("M")) {
            type = TypeOptBfor.JOPT;
        } else if (!Pattern.matches("^[h?dlbweznjJfcSIOxyirgpa]*$", arg.substring(1))) {
            Panc.catchError(1, arg);
        } else if (lastArg && !Pattern.matches("^[h?]*$", arg.substring(1))) {
            for (String opt : endingOptChar) {
                if (!arg.endsWith(opt)) continue;
                Panc.catchError(3, arg);
            }
        } else {
            for (int i = 1; i < arg.length() - 1; ++i) {
                int numerror = Panc.calcNumError(arg.substring(i, i + 1));
                if (numerror == 0) continue;
                Panc.catchError(numerror, arg.substring(i + 1));
            }
            if (Pattern.matches("^[h?]*$", arg.substring(1))) {
                Panc.postHelp();
                System.exit(-1);
            } else if (Pattern.matches("[jJfSIOxir]", arg.substring(arg.length() - 1))) {
                type = TypeOptBfor.OPTARG;
            } else if (arg.substring(arg.length() - 1).equals("p")) {
                type = TypeOptBfor.DEPR;
            }
        }
        return type;
    }

    public static TypeOptBfor verifyCompleteStringOpt(String arg, Vector<String> authorizedOptArg, Vector<String> authorizedOpt, boolean lastArg) {
        TypeOptBfor type = TypeOptBfor.NOARG;
        boolean optok = false;
        boolean optarg = false;
        String option = null;
        Pattern p = Pattern.compile("=");
        String[] opts = p.split(arg, 2);
        if (opts.length < 2) {
            option = arg.substring(2);
        } else {
            for (String opt : authorizedOptArg) {
                if (!opt.equals(opts[0].substring(2)) || opts[1].length() >= 1) continue;
                int numerror = Panc.calcNumError(opts[0].substring(2));
                Panc.catchError(numerror, "");
            }
            option = opts[0].substring(2);
        }
        for (String opt : authorizedOpt) {
            if (!opt.equals(option)) continue;
            optok = true;
        }
        for (String opt : authorizedOptArg) {
            if (!opt.equals(option)) continue;
            optarg = true;
        }
        if (!optok) {
            Panc.catchError(1, option);
        } else if (!optarg && arg.indexOf("=") >= 0) {
            Panc.catchError(1, arg);
        } else if (lastArg && opts.length < 2 && !option.equals("help") && !option.equals("usage")) {
            Panc.catchError(3, arg);
        } else if (option.equals("java-opts") && opts.length < 2) {
            type = TypeOptBfor.JOPT;
        } else if (option.equals("java-opts") && opts.length == 2) {
            type = TypeOptBfor.NOARG;
        } else if (option.equals("help") || option.equals("usage")) {
            Panc.postHelp();
            System.exit(-1);
        } else if (optarg) {
            if (opts.length < 2) {
                type = option.equals("deprecation") ? TypeOptBfor.DEPR : TypeOptBfor.OPTARG;
            } else if (opts.length >= 2) {
                type = TypeOptBfor.ARG;
            }
        }
        return type;
    }

    public static int launchCompiler(Vector<String> options, Vector<String> arguments, Vector<String> paths) {
        File annotationOutputDirectory = null;
        File annotationBaseDirectory = null;
        boolean xmlWriteEnabled = true;
        boolean depWriteEnabled = false;
        Formatter formatter = FormatterUtils.getDefaultFormatterInstance();
        int iteration = 5000;
        int callDepth = 10;
        File outputDirectory = new File(System.getProperty("user.dir"));
        File sessionDirectory = null;
        File includDir = null;
        File filePath = null;
        File objectsFile = null;
        boolean gzip = false;
        int deprecation = 0;
        boolean failOnWarn = false;
        boolean verbose = false;
        String logging = "";
        String logfilename = "";
        String rootElement = null;
        File logfile = null;
        LinkedList<Pattern> debugIncludePatterns = new LinkedList<Pattern>();
        LinkedList<Pattern> debugExcludePatterns = new LinkedList<Pattern>();
        LinkedList<File> includeDirectories = new LinkedList<File>();
        LinkedList<File> includeFiles = new LinkedList<File>();
        LinkedList<String> objectOutput = new LinkedList<String>();
        int compteur = 0;
        for (String opt : options) {
            Integer i;
            Pattern p;
            if (opt.equals("d") || opt.equals("debug")) {
                debugIncludePatterns.add(debugAllPattern);
            } else if (opt.equals("debug-include")) {
                p = Panc.verifyPattern(arguments.elementAt(compteur));
                debugIncludePatterns.add(p);
            } else if (opt.equals("debug-exclude")) {
                p = Panc.verifyPattern(arguments.elementAt(compteur));
                debugExcludePatterns.add(p);
            } else if (opt.equals("root-element")) {
                rootElement = arguments.elementAt(compteur);
            } else if (opt.equals("annotation-dir")) {
                annotationOutputDirectory = new File(arguments.elementAt(compteur));
                if (!annotationOutputDirectory.isAbsolute()) {
                    annotationOutputDirectory = new File(System.getProperty("user.dir"), arguments.elementAt(compteur));
                }
                Panc.veriDir(annotationOutputDirectory);
            } else if (opt.equals("annotation-base-dir")) {
                annotationBaseDirectory = new File(arguments.elementAt(compteur));
                if (!annotationBaseDirectory.isAbsolute()) {
                    annotationBaseDirectory = new File(System.getProperty("user.dir"), arguments.elementAt(compteur));
                }
                Panc.veriDir(annotationBaseDirectory);
            } else if (opt.equals("z") || opt.equals("xml-write")) {
                xmlWriteEnabled = true;
            } else if (opt.equals("n") || opt.equals("no-xml-write")) {
                xmlWriteEnabled = false;
            } else if (opt.equals("y") || opt.equals("dependency")) {
                depWriteEnabled = true;
            } else if (opt.equals("c") || opt.equals("check")) {
                xmlWriteEnabled = false;
                depWriteEnabled = false;
            } else if (opt.equals("x") || opt.equals("xml-style")) {
                String formatterName = arguments.elementAt(compteur);
                formatter = FormatterUtils.getFormatterInstance(formatterName);
                if (formatter == null) {
                    Panc.catchError("Invalid XML style: " + formatterName);
                }
            } else if (opt.equals("i") || opt.equals("max-iteration")) {
                i = new Integer(arguments.elementAt(compteur));
                iteration = i;
            } else if (opt.equals("r") || opt.equals("max-recursion")) {
                i = new Integer(arguments.elementAt(compteur));
                callDepth = i;
            } else if (opt.equals("O") || opt.equals("output-dir")) {
                outputDirectory = new File(arguments.elementAt(compteur));
                if (!outputDirectory.isAbsolute()) {
                    outputDirectory = new File(System.getProperty("user.dir"), arguments.elementAt(compteur));
                }
                Panc.veriDir(outputDirectory);
            } else if (opt.equals("S") || opt.equals("session-dir")) {
                sessionDirectory = new File(arguments.elementAt(compteur));
                if (!sessionDirectory.isAbsolute()) {
                    sessionDirectory = new File(System.getProperty("user.dir"), arguments.elementAt(compteur));
                }
                Panc.veriDir(sessionDirectory);
            } else if (opt.equals("I") || opt.equals("include-dir")) {
                includDir = new File(arguments.elementAt(compteur));
                if (!includDir.isAbsolute()) {
                    includDir = new File(System.getProperty("user.dir"), arguments.elementAt(compteur));
                }
                Panc.veriDir(includDir);
                if (!includeDirectories.contains(includDir)) {
                    includeDirectories.add(includDir);
                }
            } else if (opt.equals("f") || opt.equals("file")) {
                filePath = new File(arguments.elementAt(compteur));
                if (!filePath.isAbsolute()) {
                    filePath = new File(System.getProperty("user.dir"), arguments.elementAt(compteur));
                }
                LinkedList<String> fileName = Panc.readFile(filePath);
                for (String name : fileName) {
                    File file = new File(name);
                    includeFiles.add(file);
                }
            } else if (opt.equals("J") || opt.equals("objects-file")) {
                objectsFile = new File(arguments.elementAt(compteur));
                objectOutput = Panc.readFile(objectsFile);
            } else if (opt.equals("j") || opt.equals("objects")) {
                objectOutput = Panc.splitObject(arguments.elementAt(compteur), objectOutput);
            } else if (opt.equals("g") || opt.equals("gzip")) {
                gzip = true;
            } else if (opt.equals("p") || opt.equals("deprecation")) {
                i = new Integer(arguments.elementAt(compteur));
                deprecation = i;
            } else if (opt.equals("a") || opt.equals("verbose")) {
                verbose = true;
            } else if (opt.equals("logging")) {
                logging = arguments.elementAt(compteur);
                CompilerLogging.activateLoggers(logging);
            } else if (opt.equals("logfile")) {
                logfilename = arguments.elementAt(compteur);
                logfile = new File(logfilename);
                if (logfile != null) {
                    CompilerLogging.setLogFile(logfile);
                }
            } else if (opt.equals("failonwarn")) {
                failOnWarn = true;
            }
            ++compteur;
        }
        for (String path : paths) {
            File path2include = new File(path);
            Panc.veriFile(path2include);
            includeFiles.add(path2include);
        }
        try {
            CompilerOptions coptions = new CompilerOptions(debugIncludePatterns, debugExcludePatterns, xmlWriteEnabled, depWriteEnabled, iteration, callDepth, formatter, outputDirectory, sessionDirectory, includeDirectories, 0, gzip, deprecation, false, annotationOutputDirectory, annotationBaseDirectory, failOnWarn, rootElement);
            CompilerResults results = Compiler.run(coptions, objectOutput, includeFiles);
            String errors = results.formatErrors();
            if (errors != null) {
                System.err.println(errors);
            }
            if (verbose) {
                System.out.println(results.formatStats());
            }
            return errors != null ? 1 : 0;
        }
        catch (SyntaxException e) {
            Panc.catchError(e.getMessage());
            return 1;
        }
    }

    public static void postHelp() {
        System.out.printf("Usage: panc [OPTIONS] [--] [PATHS...]\n\n", new Object[0]);
        System.out.printf(" -d,--debug                   enable all pan debug/traceback functions\n", new Object[0]);
        System.out.printf("    --debug-include           enable regex for debug/traceback functions\n", new Object[0]);
        System.out.printf("    --debug-exclude           exclude regex debug/traceback functions\n", new Object[0]);
        System.out.printf("    --root-element            set root element; must be an nlist\n", new Object[0]);
        System.out.printf("    --annotation-dir=PATH     where to store the annotation files\n", new Object[0]);
        System.out.printf("    --annotation-base-dir=PATH source base directory for generating anno. files\n", new Object[0]);
        System.out.printf(" -a,--verbose                 shows statistics\n", new Object[0]);
        System.out.printf(" -z,--xml-write               write machine config. files (usually XML files)\n", new Object[0]);
        System.out.printf(" -n,--no-xml-write            disallow write machine configuration files\n", new Object[0]);
        System.out.printf(" -j,--objects=NAMES           objects to output (comma separated list)\n", new Object[0]);
        System.out.printf(" -J,--objects-file=NAME       file with list of objects to output\n", new Object[0]);
        System.out.printf(" -f,--file=NAME               file containing paths of files to process\n", new Object[0]);
        System.out.printf(" -c,--check                   only check the syntax of the given source files\n", new Object[0]);
        System.out.printf(" -S,--session-dir=PATH        which session directory to use (default is NULL)\n", new Object[0]);
        System.out.printf(" -I,--include-dir=PATH        which source directory to consider (default is .)\n", new Object[0]);
        System.out.printf(" -O,--output-dir=PATH         where to store the output files (default is .)\n", new Object[0]);
        System.out.printf(" -x,--xml-style=STRING        select the XML output style (default is pan)\n", new Object[0]);
        System.out.printf(" -y,--dependency              output dependency information\n", new Object[0]);
        System.out.printf(" -i,--max-iteration=NUMBER    set max. number of iterations (default is 10000)\n", new Object[0]);
        System.out.printf(" -r,--max-recursion=NUMBER    set max. number of recursions (default is 10)\n", new Object[0]);
        System.out.printf(" -g,--gzip                    compress the machine config. files\n", new Object[0]);
        System.out.printf(" -p,--deprecation=NUMBER      set deprecation level (default is 0)\n", new Object[0]);
        System.out.printf("    --failonwarn              treat warnings as errors\n", new Object[0]);
        System.out.printf("    --java-opts=STRING        define java options\n", new Object[0]);
        System.out.printf(" -k,--noconf                  panc does not use any configuration file\n", new Object[0]);
        System.out.printf("    --logging=STRING          enable logging from the command line\n", new Object[0]);
        System.out.printf("    --logfile=STRING          set the name of the log file to write\n", new Object[0]);
        System.out.printf(" -v,--version                 print the version of the compiler\n", new Object[0]);
        System.out.printf(" -h,--help                    print this help message\n", new Object[0]);
        System.out.printf(" -?,--usage                   print this help message\n", new Object[0]);
    }

    public static int calcNumError(String arg) {
        int numerror = 0;
        if (arg.equals("session-dir") || arg.equals("include-dir") || arg.equals("output-dir") || Pattern.matches("[SIO]", arg)) {
            numerror = 2;
        } else if (arg.equals("objects") || arg.equals("deprecation") || arg.equals("max-iteration") || arg.equals("max-recursion") || Pattern.matches("[jpir]", arg)) {
            numerror = 5;
        } else if (arg.equals("objects-file") || arg.equals("output-dir") || Pattern.matches("[Jf]", arg)) {
            numerror = 4;
        }
        return numerror;
    }

    public static void catchError(String error) {
        System.err.println("panc: " + error + "\n");
        Panc.postHelp();
        System.exit(-1);
    }

    public static void catchError(int numerror, String arg) {
        Vector<String> error = new Vector<String>();
        error.addElement("unrecognized option: " + arg);
        error.addElement("Not an existing directory path: " + arg);
        error.addElement("option requires an argument: " + arg);
        error.addElement("Can't open file: " + arg + "\ninput in flex scanner failed");
        error.addElement("input in flex scanner failed");
        System.err.println("panc: " + (String)error.elementAt(numerror - 1));
        System.err.printf("\n", new Object[0]);
        Panc.postHelp();
        System.exit(-1);
    }

    public static LinkedList<String> splitObject(String objlist, LinkedList<String> objectOutput) {
        String[] objects;
        Pattern p = Pattern.compile(",");
        for (String obj : objects = p.split(objlist)) {
            objectOutput.add(obj);
        }
        return objectOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<String> readFile(File file) {
        LinkedList<String> objects = new LinkedList<String>();
        BufferedReader bfrd = null;
        Panc.veriFile(file);
        boolean error = false;
        try {
            String ligne;
            bfrd = new BufferedReader(new FileReader(file));
            while ((ligne = bfrd.readLine()) != null) {
                if (ligne.equals("")) continue;
                objects.add(ligne);
            }
        }
        catch (FileNotFoundException exc) {
            System.out.println("File " + file.getName() + " Opening Error");
            error = true;
        }
        catch (IOException e) {
            System.out.println("Reading " + file.getName() + " Error");
            error = true;
        }
        finally {
            try {
                if (bfrd != null) {
                    bfrd.close();
                }
            }
            catch (IOException e) {
                System.out.println("Closing " + file.getName() + " Error");
                error = true;
            }
        }
        if (error) {
            System.exit(-1);
        }
        return objects;
    }

    public static void veriDir(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            System.out.println("can't open " + dir.getAbsolutePath() + ": No such file or directory");
            System.exit(-1);
        }
    }

    public static void veriFile(File file) {
        if (!file.exists() || !file.isFile()) {
            System.out.println("can't open " + file.getAbsolutePath() + ": No such file or directory");
            System.exit(-1);
        }
    }

    public static Pattern verifyPattern(String regex) {
        Pattern p = null;
        try {
            p = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            System.out.println("Invalid regular expression: " + e.getMessage());
        }
        return p;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypeOptBfor {
        BEGIN,
        OPTARG,
        NOARG,
        DMINUS,
        ARG,
        JOPT,
        DEPR,
        END;

    }
}

