/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.functions;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.LongProperty;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.dml.functions.BuiltInFunction;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public final class Substr
extends BuiltInFunction {
    private Substr(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        super("substr", sourceRange, operations);
    }

    public static Operation getInstance(SourceRange sourceRange, Operation ... operations) throws SyntaxException {
        if (operations.length < 2 || operations.length > 3) {
            throw SyntaxException.create(sourceRange, "MSG_2_OR_3_ARGS", "substr");
        }
        return new Substr(sourceRange, operations);
    }

    public Element execute(Context context) {
        assert (this.ops.length == 2 || this.ops.length == 3);
        String string = null;
        try {
            string = ((StringProperty)this.ops[0].execute(context)).getValue();
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("first argument to substr() must be a string", this.getSourceRange(), context);
        }
        int start = 0;
        try {
            long slong = ((LongProperty)this.ops[1].execute(context)).getValue();
            if (slong > Integer.MAX_VALUE || slong < Integer.MIN_VALUE) {
                throw new EvaluationException("second argument to substr() cannot be converted to int: " + slong, this.getSourceRange(), context);
            }
            start = (int)slong;
            if (start < 0) {
                start = string.length() + start;
            }
            if (start > string.length()) {
                throw new EvaluationException("start index in substr() is greater than the string length", this.getSourceRange(), context);
            }
            if (start < 0) {
                throw new EvaluationException("start index in substr() is less than zero", this.getSourceRange(), context);
            }
        }
        catch (ClassCastException cce) {
            throw new EvaluationException("second argument to substr() must be a long", this.getSourceRange(), context);
        }
        int end = string.length();
        if (this.ops.length == 3) {
            try {
                long slong = ((LongProperty)this.ops[2].execute(context)).getValue();
                if (slong > Integer.MAX_VALUE || slong < Integer.MIN_VALUE) {
                    throw new EvaluationException("third argument to substr() cannot be converted to int: " + slong, this.getSourceRange(), context);
                }
                int temp = (int)slong;
                end = temp >= 0 ? start + temp : string.length() + temp;
                if (end > string.length()) {
                    throw new EvaluationException("end index in substr() is greater than the string length", this.getSourceRange(), context);
                }
                if (end < 0) {
                    throw new EvaluationException("end index in substr() is less than zero", this.getSourceRange(), context);
                }
            }
            catch (ClassCastException cce) {
                throw new EvaluationException("second and optional third arguments to substr() must be longs", this.getSourceRange(), context);
            }
            if (end < start) {
                throw new EvaluationException("start index is after ending index in substr()", this.getSourceRange(), context);
            }
        }
        return StringProperty.getInstance(string.substring(start, end));
    }
}

