/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.dml.operators;

import org.quattor.pan.dml.AbstractOperation;
import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.BooleanProperty;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.MessageUtils;

public final class For
extends AbstractOperation {
    public For(SourceRange sourceRange, Operation ... ops) {
        super(sourceRange, ops);
        assert (ops.length == 4);
    }

    public Element execute(Context context) {
        Operation initialization = this.ops[0];
        Operation condition = this.ops[1];
        Operation increment = this.ops[2];
        Operation body = this.ops[3];
        Element result = initialization.execute(context);
        boolean test = false;
        try {
            test = ((BooleanProperty)condition.execute(context)).getValue();
        }
        catch (ClassCastException cce) {
            throw new EvaluationException(MessageUtils.format("MSG_INVALID_LOOP_TEST", new Object[0]), this.sourceRange, context);
        }
        int limit = context.getIterationLimit();
        int count = 0;
        while (test) {
            if (++count > limit) {
                throw new EvaluationException(MessageUtils.format("MSG_LOOP_ITERATION_LIMIT", limit), this.sourceRange, context);
            }
            result = body.execute(context);
            increment.execute(context);
            try {
                test = ((BooleanProperty)condition.execute(context)).getValue();
            }
            catch (ClassCastException cce) {
                throw new EvaluationException(MessageUtils.format("MSG_INVALID_LOOP_TEST", new Object[0]), this.sourceRange, context);
            }
        }
        return result;
    }
}

