/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.exceptions;

import java.util.List;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Path;
import org.quattor.pan.utils.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidTermException
extends Exception {
    private String errorPath = null;
    private String actualType = null;

    public InvalidTermException(String message) {
        super(message);
    }

    public InvalidTermException setInfo(Term[] terms, int index, String actualType) {
        this.actualType = actualType;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= index; ++i) {
            if (i > 0) {
                sb.append("/");
            }
            sb.append(((Object)terms[i]).toString());
        }
        this.errorPath = sb.toString();
        return this;
    }

    public InvalidTermException setVariableInfo(List<Term> terms, int index, String actualType) {
        this.actualType = actualType;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= index; ++i) {
            sb.append("[");
            sb.append(((Object)terms.get(i)).toString());
            sb.append("]");
        }
        this.errorPath = sb.toString();
        return this;
    }

    public String formatMessage(Path path) {
        StringBuilder sb = new StringBuilder();
        if (path.isAbsolute()) {
            sb.append("/");
        } else if (path.isExternal()) {
            sb.append(path.getAuthority());
            sb.append(":");
        }
        if (this.errorPath != null) {
            sb.append(this.errorPath);
        }
        return MessageUtils.format("MSG_INVALID_PATH_DEREFERENCE", this.actualType, this.getMessage(), sb.toString(), path.toString());
    }

    public String formatVariableMessage(String name, Term[] terms) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        if (terms != null) {
            for (Term term : terms) {
                sb.append("[");
                sb.append(((Object)term).toString());
                sb.append("]");
            }
        }
        return MessageUtils.format("MSG_INVALID_PATH_DEREFERENCE", this.actualType, this.getMessage(), name + this.errorPath, name);
    }
}

