/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.output;

import java.io.PrintWriter;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Property;
import org.quattor.pan.dml.data.Resource;
import org.quattor.pan.dml.data.StringProperty;
import org.quattor.pan.output.Formatter;

public class DotFormatter
implements Formatter {
    private static final DotFormatter instance = new DotFormatter();
    private static final String suffix = "dot";
    private static final String key = "dot";

    private DotFormatter() {
    }

    public static DotFormatter getInstance() {
        return instance;
    }

    public String getFileExtension() {
        return "dot";
    }

    public String getFormatKey() {
        return "dot";
    }

    public void write(Element root, String rootName, PrintWriter ps) {
        this.writeHeader(rootName, ps);
        this.writeRoot(rootName, root, ps);
        this.writeFooter(ps);
    }

    private void writeRoot(String myName, Element node, PrintWriter ps) {
        String tagName = node.getTypeAsString();
        if (node instanceof StringProperty && !"string".equals(tagName)) {
            tagName = "string";
        }
        String myPath = "/" + myName;
        ps.append("\"" + myPath + "\" [ label = \"" + myName + "\"]\n");
        if (node instanceof Resource) {
            Resource resource = (Resource)node;
            for (Resource.Entry entry : resource) {
                String nameChild = ((Property)entry.getKey()).toString();
                this.writeChild(myPath, nameChild, (Element)entry.getValue(), ps);
            }
        }
    }

    private void writeChild(String parentPath, String myName, Element node, PrintWriter ps) {
        String type = node.getTypeAsString();
        String myPath = parentPath + "/" + myName;
        if (node instanceof Resource) {
            ps.append("\"" + myPath + "\" [ label = \"" + myName + "\" ]\n");
            ps.append("\"" + parentPath + "\" -> \"" + myPath + "\"\n");
            Resource resource = (Resource)node;
            for (Resource.Entry entry : resource) {
                String nameChild = ((Property)entry.getKey()).toString();
                this.writeChild(myPath, nameChild, (Element)entry.getValue(), ps);
            }
        } else {
            String s = ((Property)node).toString();
            String quote = "string".equals(type) ? "'" : "";
            s = this.fixString(s, quote);
            ps.append("\"" + myPath + "\" [ label = \"" + myName + "\\n" + s + "\" ]\n");
            ps.append("\"" + parentPath + "\" -> \"" + myPath + "\"\n");
        }
    }

    private void writeHeader(String rootName, PrintWriter ps) {
        ps.append("digraph \"" + rootName + "\" {\n" + "bgcolor = beige\n" + "node [ color = black, shape = box, fontname=Helvetica ]\n" + "edge [ color = black ]\n");
    }

    private void writeFooter(PrintWriter ps) {
        ps.append("}\n");
    }

    private String fixString(String s, String quote) {
        StringBuilder sb = new StringBuilder(quote);
        sb.append(s.replaceAll("[\\n\\r]+", " "));
        if (sb.length() > 15) {
            sb.setLength(12);
            sb.append("...");
        }
        sb.append(quote);
        return sb.toString();
    }
}

