/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.output;

import java.util.HashMap;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.output.DotFormatter;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.output.PanFormatter;
import org.quattor.pan.output.TxtFormatter;
import org.quattor.pan.output.XmlDBFormatter;

public class FormatterUtils {
    private static final HashMap<String, Formatter> formatters;
    private static final Formatter defaultFormatter;

    public static Formatter getFormatterInstance(String name) {
        String key = name != null ? name.toLowerCase() : "";
        return formatters.get(key);
    }

    public static Formatter getDefaultFormatterInstance() {
        return defaultFormatter;
    }

    static {
        Formatter[] instances;
        formatters = new HashMap();
        for (Formatter f : instances = new Formatter[]{DotFormatter.getInstance(), PanFormatter.getInstance(), TxtFormatter.getInstance(), XmlDBFormatter.getInstance()}) {
            String key = f.getFormatKey().toLowerCase();
            Formatter existingValue = formatters.put(key, f);
            if (existingValue == null) continue;
            throw CompilerError.create("MSG_DUPLICATE_FORMATTER_KEY", new Object[0]);
        }
        defaultFormatter = PanFormatter.getInstance();
    }
}

