/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.repository.FileSystemSourceRepositoryWithSessionDir;
import org.quattor.pan.repository.FileSystemSourceRepositoryWithoutSessionDir;
import org.quattor.pan.repository.Parameter;
import org.quattor.pan.repository.ParameterList;
import org.quattor.pan.repository.SourceFile;
import org.quattor.pan.repository.SourceRepository;
import org.quattor.pan.repository.SourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileSystemSourceRepository
implements SourceRepository {
    protected static final List<String> emptyRelativePaths;
    protected static final List<String> sourceFileExtensions;

    protected FileSystemSourceRepository() {
    }

    public static SourceRepository getInstance(ParameterList parameters) {
        if (parameters == null) {
            parameters = new ParameterList();
        }
        File sessionDirectory = null;
        ArrayList<File> includeDirectories = new ArrayList<File>();
        for (Parameter parameter : parameters) {
            String name = parameter.getKey();
            if ("sessionDirectory".equals(name)) {
                sessionDirectory = new File(parameter.getValue());
                continue;
            }
            if (!"includeDirectory".equals(name)) continue;
            includeDirectories.add(new File(parameter.getValue()));
        }
        if (sessionDirectory == null) {
            return new FileSystemSourceRepositoryWithoutSessionDir(includeDirectories);
        }
        return new FileSystemSourceRepositoryWithSessionDir(sessionDirectory, includeDirectories);
    }

    public abstract File lookupSource(String var1);

    public abstract File lookupSource(String var1, List<String> var2);

    public abstract File lookupText(String var1);

    public abstract File lookupText(String var1, List<String> var2);

    @Override
    public SourceFile retrievePanSource(String name) {
        File file = this.lookupSource(name);
        return this.createPanSourceFile(name, file);
    }

    @Override
    public SourceFile retrievePanSource(String name, List<String> loadpath) {
        File file = this.lookupSource(name, loadpath);
        return this.createPanSourceFile(name, file);
    }

    @Override
    public SourceFile retrieveTxtSource(String name) {
        File file = this.lookupText(name);
        return this.createTxtSourceFile(name, file);
    }

    @Override
    public SourceFile retrieveTxtSource(String name, List<String> loadpath) {
        File file = this.lookupText(name, loadpath);
        return this.createTxtSourceFile(name, file);
    }

    private SourceFile createPanSourceFile(String name, File file) {
        return new SourceFile(name, true, file);
    }

    private SourceFile createTxtSourceFile(String name, File file) {
        return new SourceFile(name, false, file);
    }

    protected List<File> validateAndCopyIncludeDirectories(List<File> includeDirectories) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (includeDirectories != null && includeDirectories.size() != 0) {
            for (File d : includeDirectories) {
                if (!d.isAbsolute()) {
                    throw EvaluationException.create("MSG_NON_ABSOLUTE_PATH_IN_INCLUDE_DIRS", d.toString());
                }
                if (d.isDirectory()) continue;
                throw EvaluationException.create("MSG_NON_DIRECTORY_IN_INCLUDE_DIRS", d.toString());
            }
            dirs.addAll(includeDirectories);
        } else {
            dirs.add(new File(System.getProperty("user.dir")));
        }
        dirs.trimToSize();
        return Collections.unmodifiableList(dirs);
    }

    static {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("");
        list.trimToSize();
        emptyRelativePaths = list;
        ArrayList<String> extensions = new ArrayList<String>();
        for (SourceType type : SourceType.values()) {
            if (!type.isSource()) continue;
            extensions.add(type.getExtension());
        }
        extensions.trimToSize();
        sourceFileExtensions = Collections.unmodifiableList(extensions);
    }
}

