/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.quattor.pan.dml.Operation;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.dml.data.Undef;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.ComputedAssignmentStatement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.PathSelfHolder;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.utils.Path;

public class RelativeAssignmentStatement
extends ComputedAssignmentStatement {
    protected RelativeAssignmentStatement(SourceRange sourceRange, Path path, Operation dml, boolean conditional, boolean modifiable) throws SyntaxException {
        super(sourceRange, path, dml, conditional, modifiable);
        if (!path.isRelative()) {
            throw CompilerError.create("MSG_INVALID_PATH_ASSIGNMENT", path.toString());
        }
    }

    public void execute(Context context) throws EvaluationException {
        assert (context != null);
        try {
            PathSelfHolder selfHolder = new PathSelfHolder(this.path, context);
            context.initializeSelfHolder(selfHolder);
            Element self = selfHolder.getElement();
            assert (self != null);
            if (!this.conditional || self instanceof Undef) {
                Element result = context.executeDmlBlock(this.dml);
                if (result != null) {
                    if (result != self) {
                        result = result.duplicate();
                    }
                    context.putElement(this.path, result);
                } else {
                    context.putElement(this.path, null);
                }
            }
            context.clearSelf();
        }
        catch (EvaluationException ee) {
            throw ee.addExceptionInfo(this.getSourceRange(), context);
        }
    }
}

