/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.statement;

import org.quattor.pan.exceptions.SyntaxException;
import org.quattor.pan.statement.IncludeStatement;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;

public class StaticIncludeStatement
extends IncludeStatement {
    private final String name;

    public StaticIncludeStatement(SourceRange sourceRange, String name) throws SyntaxException {
        super(sourceRange);
        assert (name != null);
        if (!StaticIncludeStatement.validIdentifier(name)) {
            throw SyntaxException.create(sourceRange, "MSG_INVALID_IDENTIFIER", name);
        }
        this.name = name;
    }

    public void execute(Context context) {
        this.executeWithNamedTemplate(context, this.name);
    }

    public String toString() {
        return "STATIC INCLUDE: " + this.name;
    }
}

