/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.quattor.pan.Compiler;
import org.quattor.pan.CompilerLogging;
import org.quattor.pan.cache.Valid2Cache;
import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.SystemException;
import org.quattor.pan.output.Formatter;
import org.quattor.pan.tasks.Task;
import org.quattor.pan.tasks.TaskResult;
import org.quattor.pan.tasks.Valid2Result;
import org.quattor.pan.utils.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteXmlTask
extends Task<TaskResult> {
    private static final Logger taskLogger = CompilerLogging.LoggingType.TASK.logger();

    public WriteXmlTask(Formatter formatter, boolean gzipOutput, Compiler compiler, String objectName, File outputDirectory) {
        super(TaskResult.ResultType.XML, objectName, new CallImpl(formatter, gzipOutput, compiler, objectName, outputDirectory));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CallImpl
    implements Callable<TaskResult> {
        private final Formatter formatter;
        private final boolean gzipOutput;
        private final Compiler compiler;
        private final String objectName;
        private final File outputDirectory;

        public CallImpl(Formatter formatter, boolean gzipOutput, Compiler compiler, String objectName, File outputDirectory) {
            assert (formatter != null);
            this.formatter = formatter;
            this.gzipOutput = gzipOutput;
            this.compiler = compiler;
            this.objectName = objectName;
            this.outputDirectory = outputDirectory;
        }

        @Override
        public TaskResult call() throws Exception {
            Valid2Cache v2cache = this.compiler.getValid2Cache();
            Valid2Result result = (Valid2Result)v2cache.waitForResult(this.objectName);
            Element root = result.getRoot();
            long timestamp = result.timestamp;
            taskLogger.log(Level.FINER, "START_XMLFILE", this.objectName);
            URI odir = this.outputDirectory.toURI();
            URI oname = new URI(this.objectName);
            URI resolvedAbsoluteURI = odir.resolve(oname);
            String resolvedAbsolutePath = resolvedAbsoluteURI.getSchemeSpecificPart() + "." + this.formatter.getFileExtension();
            File absolutePath = new File(resolvedAbsolutePath);
            File parent = absolutePath.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new SystemException(MessageUtils.format("MSG_CANNOT_CREATE_OUTPUT_DIRECTORY", parent.getAbsolutePath()), parent);
            }
            OutputStream os = null;
            if (!this.gzipOutput) {
                os = new FileOutputStream(absolutePath);
            } else {
                absolutePath = new File(absolutePath.toString() + ".gz");
                os = new GZIPOutputStream(new FileOutputStream(absolutePath));
            }
            PrintWriter ps = new PrintWriter(os);
            this.formatter.write(root, "profile", ps);
            ps.close();
            if (!absolutePath.setLastModified(timestamp)) {
                // empty if block
            }
            taskLogger.log(Level.FINER, "END_XMLFILE", this.objectName);
            return new TaskResult(TaskResult.ResultType.XML);
        }
    }
}

