/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.type;

import org.quattor.pan.dml.data.Element;
import org.quattor.pan.exceptions.CompilerError;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.ValidationException;
import org.quattor.pan.template.Context;
import org.quattor.pan.template.SourceRange;
import org.quattor.pan.template.TypeMap;
import org.quattor.pan.type.BaseType;
import org.quattor.pan.type.FullType;
import org.quattor.pan.utils.MessageUtils;
import org.quattor.pan.utils.Range;

public class AliasType
extends BaseType {
    private final String identifier;
    private final Range range;

    public AliasType(String source, SourceRange sourceRange, String identifier, Range range) {
        super(source, sourceRange);
        assert (identifier != null);
        this.identifier = identifier;
        this.range = range;
    }

    public Element findDefault(Context context) {
        try {
            FullType type = context.getFullType(this.identifier);
            return type.findDefault(context);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw CompilerError.create("MSG_NONEXISTANT_TYPE", this.identifier);
        }
    }

    public Element setDefaults(Context context, Element self) throws EvaluationException {
        assert (context != null);
        assert (self != null);
        Element replacement = null;
        try {
            FullType type = context.getFullType(this.identifier);
            replacement = type.setDefaults(context, self);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw CompilerError.create("MSG_NONEXISTANT_TYPE", this.identifier);
        }
        return replacement;
    }

    public void validate(Context context, Element self) throws ValidationException {
        FullType type = context.getFullType(this.identifier);
        try {
            type.validate(context, self);
            if (this.range != null) {
                self.checkRange(this.range);
            }
        }
        catch (ValidationException ve) {
            throw ve.addTypeToStack(this.identifier, type);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw CompilerError.create("MSG_NONEXISTANT_TYPE", this.identifier);
        }
    }

    public void verifySubtypesDefined(TypeMap types) {
        if (types.get(this.identifier) == null) {
            throw new EvaluationException(MessageUtils.format("MSG_NONEXISTANT_REFERENCED_TYPE", this.identifier));
        }
    }

    public String toString() {
        if (this.range == null) {
            return this.identifier;
        }
        return this.identifier + "(" + this.range.toString() + ")";
    }
}

