/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.utils;

import java.util.concurrent.ExecutionException;
import org.quattor.pan.exceptions.EvaluationException;
import org.quattor.pan.exceptions.SyntaxException;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static RuntimeException launder(ExecutionException exception) {
        Throwable t = exception.getCause();
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof SyntaxException) {
            SyntaxException se = (SyntaxException)t;
            EvaluationException ee = new EvaluationException(se.getMessage());
            ee.initCause(se);
            throw ee;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new EvaluationException("unexpected throwable encountered: " + t);
    }
}

