/*
 * Decompiled with CFR 0.152.
 */
package org.quattor.pan.utils;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;

public class FileStatCache {
    private final ConcurrentHashMap<File, Long> cachedTimes = new ConcurrentHashMap();

    public boolean exists(File file) {
        return this.getModificationTime(file) > 0L;
    }

    public boolean isMissingOrModifiedAfter(File file, long targetTime) {
        long modtime = this.getModificationTime(file);
        return modtime == 0L || modtime > targetTime;
    }

    public boolean isMissingOrModifiedBefore(File file, long targetTime) {
        long modtime = this.getModificationTime(file);
        return modtime == 0L || modtime < targetTime;
    }

    public long getModificationTime(File file) {
        Long modtime = this.cachedTimes.get(file);
        if (modtime == null) {
            this.cachedTimes.putIfAbsent(file, file.lastModified());
            modtime = this.cachedTimes.get(file);
        }
        return modtime;
    }
}

