/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.config.jms.listener;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.report.Processor;
import org.qubership.automation.itf.ui.services.ContextService;
import org.qubership.automation.itf.util.MdcHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

@Component
public class ActiveMqJmsListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(ActiveMqJmsListener.class);
    private final Processor processor;
    private final MdcHelper mdcHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmsListener(destination="${message-broker.reports.queue}", containerFactory="reportingDefaultJmsListenerContainerFactory")
    public void onMessage(Message message) {
        long timeStamp = 0L;
        String objectId = null;
        String objectType = null;
        JsonObject json = null;
        String jmsMessageId = null;
        try {
            timeStamp = message.getLongProperty("Time");
            objectId = message.getStringProperty("ObjectID");
            objectType = message.getStringProperty("ObjectType");
            jmsMessageId = message.getJMSMessageID();
            String projectId = message.getStringProperty("X-Project-Id");
            MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (String)projectId);
            log.debug("Message is received: time {}, id {}, type {}", new Object[]{timeStamp, objectId, objectType});
            json = this.getJsonObject(message);
            this.addObjectTypeProperty(json, objectType);
            int partNum = message.propertyExists("partNum") ? message.getIntProperty("partNum") : ContextService.getCurrentPartitionNumberByProject(projectId);
            json.add("partNum", (JsonElement)new JsonPrimitive((Number)partNum));
            json.add("X-Project-Id", (JsonElement)new JsonPrimitive(projectId));
            this.processor.process(json, timeStamp, objectId, objectType);
            log.debug("Message is processed: time {}, id {}, type {}", new Object[]{timeStamp, objectId, objectType});
        }
        catch (Throwable e) {
            this.fillMdcFields(json);
            log.error("Error while message processing: time {}, id {}, type {}, jmsMessageId {}", new Object[]{timeStamp, objectId, objectType, jmsMessageId, e});
        }
        finally {
            MDC.clear();
        }
    }

    private JsonObject getJsonObject(Message textMessage) throws JMSException {
        return JsonParser.parseString((String)((TextMessage)textMessage).getText()).getAsJsonObject();
    }

    private void addObjectTypeProperty(@NotNull JsonObject json, String objectType) {
        if (Objects.isNull(objectType) || objectType.isEmpty()) {
            throw new IllegalArgumentException("Object type is required but missed; message processing is terminated");
        }
        json.add("objectType", (JsonElement)new JsonPrimitive(objectType));
    }

    private void fillMdcFields(JsonObject json) {
        if (Objects.isNull(json)) {
            log.error("Can't fill MDC fields, json object is null.");
            return;
        }
        this.mdcHelper.fillMdsFields(json);
    }

    public ActiveMqJmsListener(Processor processor, MdcHelper mdcHelper) {
        this.processor = processor;
        this.mdcHelper = mdcHelper;
    }
}

