/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.report.processor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonObject;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.qubership.automation.itf.report.Processor;

public abstract class AbstractProcessor
implements Processor {
    private final Cache<String, Long> lastProcessedEntity = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static final LoadingCache<String, Object> locks = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(CacheLoader.from(Object::new));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(JsonObject jsonObject, long time, String objectId, String objectType) throws SQLException, IllegalArgumentException {
        if (objectType.contains("TcContext")) {
            Object object = locks.getUnchecked((Object)objectId);
            synchronized (object) {
                Long lastTime = (Long)this.lastProcessedEntity.getIfPresent((Object)objectId);
                if (lastTime == null || lastTime < time) {
                    this.process(jsonObject);
                    this.lastProcessedEntity.put((Object)objectId, (Object)time);
                }
            }
        } else {
            this.process(jsonObject);
        }
    }

    protected abstract void process(JsonObject var1) throws SQLException;
}

