/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.report.processor;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.message.parser.MessageParameter;
import org.qubership.automation.itf.report.processor.AbstractQueryExecutor;
import org.qubership.automation.itf.report.processor.SqlQueries;
import org.qubership.automation.itf.report.statement.StatementContext;
import org.qubership.automation.itf.util.MdcHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class ExecutionReportQueryExecutor
extends AbstractQueryExecutor
implements SqlQueries {
    private static final Logger log = LoggerFactory.getLogger(ExecutionReportQueryExecutor.class);
    private static final int MAX_PG_VARCHAR_SIZE = 255;
    private static final String[] PROP_NAMES = new String[]{"name", "description"};
    private static final int[] PROP_SIZES = new int[]{255, 255};
    private static final String PART_NUM_PROPERTY_NAME = "partNum";
    private final Map<String, Storage> queryMapping = Maps.newHashMap();
    private final MdcHelper mdcHelper;
    private static String atpCatalogueUrl;

    @Autowired
    public ExecutionReportQueryExecutor(JdbcTemplate jdbcTemplate, MdcHelper mdcHelper) {
        this.mdcHelper = mdcHelper;
        this.setJdbcTemplate(jdbcTemplate);
    }

    @Value(value="${atp.catalogue.url}")
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Looks no problem with it")
    public void setAtpCatalogueUrl(String atpCatalogueUrl) {
        ExecutionReportQueryExecutor.atpCatalogueUrl = atpCatalogueUrl;
    }

    private static JsonObject trunc_propValues(JsonObject obj) {
        for (int k = 0; k < PROP_NAMES.length; ++k) {
            String val;
            JsonElement prop;
            if (!obj.has(PROP_NAMES[k]) || (prop = obj.get(PROP_NAMES[k])).isJsonNull() || !prop.isJsonPrimitive() || (val = prop.getAsString()).length() <= PROP_SIZES[k]) continue;
            obj.remove(PROP_NAMES[k]);
            obj.add(PROP_NAMES[k], (JsonElement)new JsonPrimitive(val.substring(0, PROP_SIZES[k])));
        }
        return obj;
    }

    private static String makeContextLink(Object tcContextId, String projectUuid) {
        return atpCatalogueUrl + "/project/" + projectUuid + "/itf#/context/" + tcContextId;
    }

    @PostConstruct
    private void fillQueryMap() {
        this.queryMapping.put("Combined_TcContext_Initiator", new CombinedTcContextInitiatorStorage());
        this.queryMapping.put("Combined_StepInstance_SituationInstance", new CombinedStepInstanceSituationInstance());
        this.queryMapping.put("Combined_SituationInstance_StepInstances", new CombinedSituationInstanceStepInstances());
        this.queryMapping.put("combinedFastStubMessage", new CombinedFastStubMessage());
        this.queryMapping.put(TcContext.class.getSimpleName(), new TcContextStorage());
        this.queryMapping.put(InstanceContext.class.getSimpleName(), new InstanceContextStorage());
        this.queryMapping.put(SpContext.class.getSimpleName(), new SpContextStorage());
        this.queryMapping.put(StepInstance.class.getSimpleName(), new StepInstanceStorage());
        this.queryMapping.put(SituationInstance.class.getSimpleName(), new SituationInstanceStorage());
        this.queryMapping.put(CallChainInstance.class.getSimpleName(), new CallChainInstanceStorage());
        this.queryMapping.put(Message.class.getSimpleName(), new MessageStorage());
        this.queryMapping.put(MessageParameter.class.getSimpleName(), new MessageParameterStorage());
        this.queryMapping.put("MessageParameterValue", new MessageParameterValueStorage());
        this.queryMapping.put("no", new NoStorage());
    }

    @Override
    protected Object prepareData(ResultSet resultSet, JsonObject object) {
        Long id = 0L;
        if (resultSet != null) {
            try {
                if (resultSet.next()) {
                    return resultSet.getLong(1);
                }
            }
            catch (SQLException e) {
                this.mdcHelper.fillMdsFields(object);
                log.error("ERROR in prepare data:", (Throwable)e);
                MDC.clear();
                return id;
            }
        }
        return id;
    }

    public Storage getStorageByType(String objectType) {
        if (Objects.isNull(objectType) || objectType.isEmpty()) {
            throw new IllegalArgumentException("Object type is required to process reported message correctly");
        }
        return this.queryMapping.get(objectType);
    }

    private void forEach(JsonObject object, String property, StatementContext sql, boolean truncate, boolean isMap, String parentId, String onConflict) {
        JsonObject jsonObject = new JsonObject();
        JsonElement elem = object.get(property);
        if (elem.isJsonNull()) {
            return;
        }
        if (elem.isJsonObject() && elem.getAsJsonObject().entrySet().isEmpty()) {
            return;
        }
        if (elem.isJsonArray() && elem.getAsJsonArray().isEmpty()) {
            return;
        }
        if (isMap) {
            this.forEachMapPrepareStatementContext(object, property, sql, truncate, jsonObject, parentId);
        } else {
            this.forEachPrepareStatementContext(object, property, sql, truncate, jsonObject, parentId);
        }
        if (!StringUtils.isBlank((CharSequence)onConflict)) {
            sql = sql.appendQueryPart(onConflict);
        }
        this.execute(sql, jsonObject, false);
    }

    private void forEachMap(JsonObject object, String property, StatementContext sql, boolean truncate, String onConflict) {
        this.forEach(object, property, sql, truncate, true, "id", onConflict);
    }

    private void forEachPrepareStatementContext(JsonObject object, String property, StatementContext sql, Boolean truncate, JsonObject jsonObject, String parentId) {
        int count = 1;
        jsonObject.add(PART_NUM_PROPERTY_NAME, object.get(PART_NUM_PROPERTY_NAME));
        jsonObject.add(parentId, object.get(parentId));
        JsonArray jsonArray = object.get(property).getAsJsonArray();
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            JsonElement jsonElement = (JsonElement)iterator.next();
            String valueName = "value" + count++;
            this.cutAndFixValue(truncate, jsonElement, jsonObject, valueName);
            sql = sql.appendQueryPart("(").asLong(parentId).appendQueryPart(",").asInt(PART_NUM_PROPERTY_NAME).appendQueryPart(",").asString(valueName).appendQueryPart(")");
            if (!iterator.hasNext()) continue;
            sql = sql.appendQueryPart(",");
        }
    }

    private void forEachMapPrepareStatementContext(JsonObject object, String property, StatementContext sql, Boolean truncate, JsonObject jsonObject, String idElemName) {
        JsonElement propElem = object.get(property);
        if (propElem != null && !propElem.isJsonNull()) {
            jsonObject.add(PART_NUM_PROPERTY_NAME, object.get(PART_NUM_PROPERTY_NAME));
            jsonObject.add(idElemName, object.get(idElemName));
            int count = 1;
            JsonObject jsonMap = propElem.getAsJsonObject();
            Iterator entryIterator = jsonMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)entryIterator.next();
                String keyName = "key" + count;
                String valueName = "value" + count++;
                jsonObject.add(keyName, (JsonElement)new JsonPrimitive(StringUtils.substring((String)((String)entry.getKey()), (int)0, (int)255)));
                this.cutAndFixValue(truncate, (JsonElement)entry.getValue(), jsonObject, valueName);
                sql = sql.appendQueryPart("(").asLong(idElemName).appendQueryPart(",").asInt(PART_NUM_PROPERTY_NAME).appendQueryPart(",").asString(valueName).appendQueryPart(",").asString(keyName).appendQueryPart(")");
                if (!entryIterator.hasNext()) continue;
                sql = sql.appendQueryPart(",");
            }
        }
    }

    public static String fixUnicodeZeroByteSequence(String source) {
        return StringUtils.isEmpty((CharSequence)source) ? source : source.replace("\u0000", "");
    }

    private void cutAndFixValue(boolean truncate, JsonElement value, JsonObject jsonObject, String valueName) {
        if (value.isJsonNull()) {
            jsonObject.add(valueName, value);
        } else {
            String s = ExecutionReportQueryExecutor.fixUnicodeZeroByteSequence(value.isJsonPrimitive() ? value.getAsString() : value.toString());
            jsonObject.add(valueName, (JsonElement)new JsonPrimitive(truncate && s.length() > 255 ? s.substring(0, 255) : s));
        }
    }

    private boolean isMultiple(JsonObject jsonObject) {
        if (jsonObject.has("multiple")) {
            try {
                return jsonObject.get("multiple").getAsBoolean();
            }
            catch (Exception e) {
                log.error("Error while getting 'multiple' property value from json", (Throwable)e);
            }
        }
        return false;
    }

    private static final class NoStorage
    implements Storage {
        private NoStorage() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) {
            log.warn("Unknown storage type. Data isn't stored.");
            return "NoStorage";
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) {
            return this.store(object, queryExecutor);
        }
    }

    private static final class MessageParameterValueStorage
    implements Storage {
        private MessageParameterValueStorage() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) {
            log.debug("MessageParameterValueStorage - before execute");
            JsonElement value = object.get("value");
            if (!value.isJsonNull()) {
                object.add("value", (JsonElement)new JsonPrimitive(ExecutionReportQueryExecutor.fixUnicodeZeroByteSequence(value.isJsonPrimitive() ? value.getAsString() : value.toString())));
            }
            return queryExecutor.execute(SqlQueries.STORE_MESSAGE_PARAMETER_VALUE, object, true);
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) {
            return this.store(object, queryExecutor);
        }
    }

    private static final class MessageParameterStorage
    implements Storage {
        private MessageParameterStorage() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) {
            log.debug("MessageParameterStorage - before execute");
            return queryExecutor.execute(SqlQueries.STORE_MESSAGE_PARAMETER, object, true);
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) {
            return this.store(object, queryExecutor);
        }
    }

    private static final class MessageStorage
    implements Storage {
        private MessageStorage() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) {
            log.debug("MessageStorage");
            Object messageId = queryExecutor.execute(SqlQueries.STORE_MESSAGE, object, true);
            if (messageId != null && (Long)messageId != 0L) {
                object.remove("id");
                object.add("id", (JsonElement)new JsonPrimitive((Number)((Long)messageId)));
                queryExecutor.forEachMap(object, "headers", new StatementContext().appendQueryPart(SqlQueries.STORE_MESSAGE_HEADERS.getQuery().toString()), false, "");
                queryExecutor.forEachMap(object, "connectionProperties", new StatementContext().appendQueryPart(SqlQueries.STORE_CONNECTION_PROPS.getQuery().toString()), false, "");
            }
            return messageId;
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) {
            return this.store(object, queryExecutor);
        }
    }

    private static final class CallChainInstanceStorage
    implements Storage {
        private CallChainInstanceStorage() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) {
            log.debug("CallChainInstanceStorage");
            return queryExecutor.execute(SqlQueries.STORE_CALL_CHAIN_INSTANCE, ExecutionReportQueryExecutor.trunc_propValues(object), true);
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) {
            return this.store(object, queryExecutor);
        }
    }

    private static final class SituationInstanceStorage
    implements Storage {
        private SituationInstanceStorage() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) {
            log.info("SituationInstanceStorage (to check before deletion)");
            return queryExecutor.execute(SqlQueries.UPSERT_SITUATION_INSTANCE, ExecutionReportQueryExecutor.trunc_propValues(object), true);
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) {
            return this.store(object, queryExecutor);
        }
    }

    private static final class StepInstanceStorage
    implements Storage {
        private StepInstanceStorage() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) throws SQLException {
            log.debug("StepInstanceStorage");
            JsonElement partNum = object.get(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME);
            Object id = queryExecutor.execute(SqlQueries.STORE_STEP_INSTANCE, ExecutionReportQueryExecutor.trunc_propValues(object), true);
            if (id != null && (Long)id != 0L) {
                object.addProperty("id", id.toString());
                JsonObject contextObj = object.getAsJsonObject("context");
                contextObj.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
                if (!contextObj.isJsonNull()) {
                    contextObj.addProperty("instance", id.toString());
                    queryExecutor.getStorageByType(contextObj.get("type").getAsString()).store(contextObj, queryExecutor);
                }
            }
            return id;
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) throws SQLException {
            return this.store(object, queryExecutor);
        }
    }

    private static final class CombinedSituationInstanceStepInstances
    implements Storage {
        private CombinedSituationInstanceStepInstances() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) throws SQLException {
            log.debug("CombinedSituationInstanceStepInstances");
            JsonElement partNum = object.get(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME);
            JsonObject situationInstanceObject = object.get("SituationInstance").getAsJsonObject();
            situationInstanceObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
            boolean isInitiator = object.get("isInitiator").getAsBoolean();
            Object id = queryExecutor.execute(isInitiator ? SqlQueries.UPSERT_SITUATION_INSTANCE : SqlQueries.INSERT_SITUATION_INSTANCE, ExecutionReportQueryExecutor.trunc_propValues(situationInstanceObject), true);
            JsonArray stepInstances = object.get("StepInstances").getAsJsonArray();
            if (!stepInstances.isEmpty()) {
                for (JsonElement item : stepInstances) {
                    JsonObject stepInstanceObject = item.getAsJsonObject();
                    stepInstanceObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
                    queryExecutor.getStorageByType(stepInstanceObject.get("type").getAsString()).store(stepInstanceObject, queryExecutor);
                }
            }
            return id;
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) throws SQLException {
            return this.store(object, queryExecutor);
        }
    }

    private static final class CombinedStepInstanceSituationInstance
    implements Storage {
        private CombinedStepInstanceSituationInstance() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) throws SQLException {
            log.debug("CombinedStepInstanceSituationInstance");
            JsonElement partNum = object.get(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME);
            JsonObject situationInstanceObject = object.get("SituationInstance").getAsJsonObject();
            situationInstanceObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
            queryExecutor.execute(SqlQueries.UPSERT_SITUATION_INSTANCE, ExecutionReportQueryExecutor.trunc_propValues(situationInstanceObject), true);
            JsonObject stepInstanceObject = object.get("StepInstance").getAsJsonObject();
            stepInstanceObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
            return queryExecutor.getStorageByType(stepInstanceObject.get("type").getAsString()).store(stepInstanceObject, queryExecutor);
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) throws SQLException {
            return this.store(object, queryExecutor);
        }
    }

    private static final class SpContextStorage
    implements Storage {
        private SpContextStorage() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) throws SQLException {
            log.debug("SpContextStorage");
            this.processMessage(object, queryExecutor, "incomingMessage");
            this.processMessage(object, queryExecutor, "outgoingMessage");
            Object spId = queryExecutor.execute(SqlQueries.STORE_SP_CONTEXT, ExecutionReportQueryExecutor.trunc_propValues(object), true);
            object.remove("id");
            object.add("id", (JsonElement)new JsonPrimitive((Number)((Long)spId)));
            if (!object.get("messageParameters").isJsonNull()) {
                JsonArray array = object.get("messageParameters").getAsJsonArray();
                JsonElement ctxId = object.get("id");
                JsonElement partNum = object.get(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME);
                for (JsonElement jsonMap : array) {
                    if (!jsonMap.isJsonObject()) continue;
                    JsonObject jsonObject = jsonMap.getAsJsonObject();
                    jsonObject.remove("parent");
                    jsonObject.add("parent", ctxId);
                    jsonObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
                    Object paramId = queryExecutor.getStorageByType("MessageParameter").store(jsonObject, queryExecutor);
                    if ((Long)paramId == 0L) continue;
                    if (queryExecutor.isMultiple(jsonObject)) {
                        jsonObject.addProperty("message_param_id", (Number)((Long)paramId));
                        queryExecutor.forEach(jsonObject, "multipleValue", new StatementContext().appendQueryPart(SqlQueries.STORE_MESSAGE_PARAMETER_VALUE_FE_V.getQuery().toString()), false, false, "message_param_id", "");
                        jsonObject.remove("message_param_id");
                        continue;
                    }
                    if (jsonObject.get("singleValue").isJsonNull()) continue;
                    JsonObject jsonValue = new JsonObject();
                    jsonValue.addProperty("message_param_id", (Number)((Long)paramId));
                    jsonValue.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
                    jsonValue.addProperty("value", jsonObject.get("singleValue").getAsString());
                    queryExecutor.getStorageByType("MessageParameterValue").store(jsonValue, queryExecutor);
                }
            }
            return spId;
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) throws SQLException {
            return this.store(object, queryExecutor);
        }

        private void processMessage(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String elementName) throws SQLException {
            log.debug("SpContextStorage - processMessage {}", (Object)elementName);
            if (!object.get(elementName).isJsonNull()) {
                JsonObject msgObject = object.getAsJsonObject(elementName);
                msgObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, object.get(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME));
                Long messageId = (Long)queryExecutor.getStorageByType("Message").store(msgObject, queryExecutor);
                object.remove(elementName);
                object.add(elementName, (JsonElement)(messageId == null || messageId == 0L ? JsonNull.INSTANCE : new JsonPrimitive((Number)messageId)));
            }
        }
    }

    private static final class InstanceContextStorage
    implements Storage {
        private InstanceContextStorage() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) throws SQLException {
            return this.store(object, queryExecutor, true);
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) throws SQLException {
            return "SituationInstance".equals(parentType) ? this.store(object, queryExecutor, false) : null;
        }

        private Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, boolean storeSp) throws SQLException {
            log.debug("InstanceContextStorage");
            Object id = queryExecutor.execute(SqlQueries.STORE_INSTANCE_CONTEXT, ExecutionReportQueryExecutor.trunc_propValues(object), true);
            if (object.get("id").isJsonNull()) {
                object.add("id", (JsonElement)new JsonPrimitive((Number)((Long)id)));
            }
            if (storeSp && !object.get("sp").isJsonNull()) {
                JsonObject spObject = object.getAsJsonObject("sp");
                if (spObject.get("parent").isJsonNull()) {
                    spObject.add("parent", (JsonElement)new JsonPrimitive((Number)((Long)id)));
                }
                spObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, object.get(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME));
                queryExecutor.getStorageByType(spObject.get("type").getAsString()).store(spObject, queryExecutor);
            }
            return id;
        }
    }

    private static final class TcContextStorage
    implements Storage {
        private TcContextStorage() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) {
            log.debug("TcContextStorage");
            JsonElement partNum = object.get(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME);
            JsonElement idElem = object.get("id");
            queryExecutor.execute(SqlQueries.STORE_TC_CONTEXT, ExecutionReportQueryExecutor.trunc_propValues(object), false);
            JsonArray jsonArray = object.get("bindingKeys").getAsJsonArray();
            for (JsonElement element : jsonArray) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.add("id", idElem);
                jsonObject.add("key", element);
                jsonObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
                queryExecutor.execute(SqlQueries.STORE_CONTEXT_BINDING_KEYS, jsonObject, false);
            }
            queryExecutor.forEachMap(object, "reportLinks", new StatementContext().appendQueryPart(SqlQueries.STORE_CONTEXT_REPORT_LINKS.getQuery().toString()), false, " ON CONFLICT (parent_id,\"key\", part_num) DO  UPDATE set value=EXCLUDED.value where rl.parent_id=EXCLUDED.parent_id and rl.\"key\"=EXCLUDED.\"key\"and rl.part_num=EXCLUDED.part_num");
            return idElem.getAsBigInteger();
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) {
            return this.store(object, queryExecutor);
        }
    }

    private static final class CombinedFastStubMessage
    implements Storage {
        private CombinedFastStubMessage() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) throws SQLException {
            log.debug("CombinedFastStubMessage");
            JsonElement partNum = object.get(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME);
            JsonObject initiatorObject = object.get("SituationInstance").getAsJsonObject();
            initiatorObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
            Object initiatorId = queryExecutor.execute(SqlQueries.INSERT_SITUATION_INSTANCE_GENERATE_ID, ExecutionReportQueryExecutor.trunc_propValues(initiatorObject), true);
            JsonObject tcContextObject = object.get("TcContext").getAsJsonObject();
            tcContextObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
            tcContextObject.add("initiator", (JsonElement)new JsonPrimitive((Number)((Long)initiatorId)));
            Object tcContextId = queryExecutor.execute(SqlQueries.INSERT_TC_CONTEXT_GENERATE_ID, ExecutionReportQueryExecutor.trunc_propValues(tcContextObject), true);
            tcContextObject.add("id", (JsonElement)new JsonPrimitive((Number)((Long)tcContextId)));
            JsonObject reportLinks = tcContextObject.get("reportLinks").getAsJsonObject();
            reportLinks.add("ITF context link", (JsonElement)new JsonPrimitive(ExecutionReportQueryExecutor.makeContextLink(tcContextId, tcContextObject.get("projectUuid").getAsString())));
            queryExecutor.forEachMap(tcContextObject, "reportLinks", new StatementContext().appendQueryPart(SqlQueries.STORE_CONTEXT_REPORT_LINKS.getQuery().toString()), false, "");
            initiatorObject.add("id", (JsonElement)new JsonPrimitive((Number)((Long)initiatorId)));
            initiatorObject.add("parentContext", (JsonElement)new JsonPrimitive((Number)((Long)tcContextId)));
            queryExecutor.execute(SqlQueries.UPDATE_SITUATION_INSTANCE, initiatorObject, false);
            JsonObject stepInstanceObject = object.get("StepInstance").getAsJsonObject();
            stepInstanceObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
            stepInstanceObject.add("parent", (JsonElement)new JsonPrimitive((Number)((Long)initiatorId)));
            return queryExecutor.getStorageByType(stepInstanceObject.get("type").getAsString()).store(stepInstanceObject, queryExecutor);
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) throws SQLException {
            return this.store(object, queryExecutor);
        }
    }

    private static final class CombinedTcContextInitiatorStorage
    implements Storage {
        private CombinedTcContextInitiatorStorage() {
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor) throws SQLException {
            log.debug("CombinedTcContextInitiatorStorage");
            JsonElement partNum = object.get(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME);
            JsonObject initiatorObject = object.get("Initiator").getAsJsonObject();
            initiatorObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
            String initiatorType = initiatorObject.get("type").getAsString();
            queryExecutor.execute("SituationInstance".equals(initiatorType) ? SqlQueries.UPSERT_SITUATION_INSTANCE : SqlQueries.STORE_CALL_CHAIN_INSTANCE, ExecutionReportQueryExecutor.trunc_propValues(initiatorObject), true);
            JsonObject tcContextObject = object.get("TcContext").getAsJsonObject();
            tcContextObject.add(ExecutionReportQueryExecutor.PART_NUM_PROPERTY_NAME, partNum);
            return queryExecutor.getStorageByType(tcContextObject.get("type").getAsString()).store(tcContextObject, queryExecutor);
        }

        @Override
        public Object store(JsonObject object, ExecutionReportQueryExecutor queryExecutor, String parentType) throws SQLException {
            return this.store(object, queryExecutor);
        }
    }

    public static interface Storage {
        public Object store(JsonObject var1, ExecutionReportQueryExecutor var2) throws SQLException;

        public Object store(JsonObject var1, ExecutionReportQueryExecutor var2, String var3) throws SQLException;
    }
}

