/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.report.statement;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.report.statement.AbstractSetter;
import org.qubership.automation.itf.report.statement.Setter;

public class StatementContext {
    private final StringBuilder query = new StringBuilder();
    private final List<Setter> params = Lists.newArrayList();

    @Nonnull
    public StringBuilder getQuery() {
        return this.query;
    }

    public void addParameter(@Nonnull Setter setter) {
        this.params.add(setter);
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Only application-controlled code can be here")
    public PreparedStatement prepare(JsonObject json, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(this.getQuery().toString());
            int i = 1;
            for (Setter s : this.params) {
                i = s.set(json, statement, i);
            }
            return statement;
        }
        catch (SQLException ex) {
            if (statement != null) {
                statement.close();
            }
            throw ex;
        }
    }

    public List<String> getParameters() {
        ArrayList params = Lists.newArrayList();
        for (Setter property : this.params) {
            params.add(property.getProperty());
        }
        return params;
    }

    public StatementContext appendQueryPart(String queryPart) {
        this.getQuery().append(queryPart);
        return this;
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Old code; and not so clear how to fix")
    public StatementContext asLong(String prop) {
        this.addParameter(new AbstractSetter(prop, -5){

            @Override
            protected Object convertJsonValue(JsonElement element) {
                return element.getAsLong();
            }
        });
        this.getQuery().append("?");
        return this;
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Old code; and not so clear how to fix")
    public StatementContext asInt(String prop) {
        this.addParameter(new AbstractSetter(prop, 4){

            @Override
            protected Object convertJsonValue(JsonElement element) {
                return element.getAsInt();
            }
        });
        this.getQuery().append("?");
        return this;
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Old code; and not so clear how to fix")
    public StatementContext asDate(String prop) {
        this.addParameter(new AbstractSetter(prop, 91){

            @Override
            protected Object convertJsonValue(JsonElement element) {
                long dateLong = element.getAsLong();
                return new Date(dateLong);
            }
        });
        this.getQuery().append("?");
        return this;
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Old code; and not so clear how to fix")
    public StatementContext asDataTime(String prop) {
        this.addParameter(new AbstractSetter(prop, 93){

            @Override
            protected Object convertJsonValue(JsonElement element) {
                long dateLong = element.getAsLong();
                return new Timestamp(dateLong);
            }
        });
        this.getQuery().append("?");
        return this;
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Old code; and not so clear how to fix")
    public StatementContext asBoolean(String prop) {
        this.addParameter(new AbstractSetter(prop, 16){

            @Override
            protected Object convertJsonValue(JsonElement element) {
                return element.getAsBoolean();
            }
        });
        this.getQuery().append("?");
        return this;
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Old code; and not so clear how to fix")
    public StatementContext asString(String prop) {
        this.addParameter(new AbstractSetter(prop, 12){

            @Override
            protected Object convertJsonValue(JsonElement element) {
                return element.getAsString();
            }
        });
        this.getQuery().append("?");
        return this;
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Old code; and not so clear how to fix")
    public StatementContext asStringFixedZero(String prop) {
        this.addParameter(new AbstractSetter(prop, 12){

            @Override
            protected Object convertJsonValue(JsonElement element) {
                return element.getAsString().replace("\u0000", "");
            }
        });
        this.getQuery().append("?");
        return this;
    }
}

