/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.PreDestroy;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.UpgradeHistoryObjectManager;
import org.qubership.automation.itf.core.model.jpa.versions.UpgradeHistory;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.listener.AbstractJmsListeningContainer;
import org.springframework.stereotype.Component;

@Component
public class UiContextListener {
    private static final Logger log = LoggerFactory.getLogger(UiContextListener.class);
    private final ApplicationContext myContext;
    private final LockManager lockManager;
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean multiTenancyEnabled;

    public void contextInitialized() {
        this.lockManager.executeWithLock("upgrade_history", this::upgradeHistory);
        this.startingJmsListenerContainer();
        log.info("Reporting service initialization completed");
    }

    public void contextDestroyed() {
    }

    @EventListener
    public void init(ContextRefreshedEvent event) {
        if (event.getSource().equals(this.myContext)) {
            this.contextInitialized();
        }
    }

    @PreDestroy
    public void destroyed() {
        this.contextDestroyed();
    }

    private void startingJmsListenerContainer() {
        log.info("Getting JmsListenerContainerFactories...");
        DefaultJmsListenerContainerFactory factory = (DefaultJmsListenerContainerFactory)this.myContext.getBean("reportingDefaultJmsListenerContainerFactory");
        factory.setAutoStartup(true);
        log.info("JmsListenerContainerFactories: setAutoStartup is set to true.");
        log.info("Getting JmsListenerEndpointRegistry...");
        JmsListenerEndpointRegistry jmsListenerEndpointRegistry = (JmsListenerEndpointRegistry)this.myContext.getBean(JmsListenerEndpointRegistry.class);
        log.info("Setting 'autoStartup' to true for all JMS Listeners...");
        jmsListenerEndpointRegistry.getListenerContainers().forEach(messageListenerContainer -> ((AbstractJmsListeningContainer)messageListenerContainer).setAutoStartup(true));
        log.info("All JMS Listeners are ready. Starting jmsListenerEndpointRegistry...");
        jmsListenerEndpointRegistry.start();
        log.info("JmsListenerEndpointRegistry is started.");
    }

    private void upgradeHistory() {
        if (this.multiTenancyEnabled.booleanValue()) {
            Collection clusters = TenantContext.getTenantIds((boolean)true);
            for (String cluster : clusters) {
                TenantContext.setTenantInfo((String)cluster);
                this.doUpgradeHistory();
            }
            TenantContext.setDefaultTenantInfo();
        }
        this.doUpgradeHistory();
    }

    private void doUpgradeHistory() {
        UpgradeHistory upgradeHistories = ((UpgradeHistoryObjectManager)CoreObjectManager.getInstance().getSpecialManager(UpgradeHistory.class, UpgradeHistoryObjectManager.class)).findLastVersion();
        String buildVersionString = this.getCurrentBuildVersion();
        if (buildVersionString != null) {
            String currentBuildVersion = buildVersionString.replaceFirst("application.version=", "");
            if (Objects.isNull(upgradeHistories) || !currentBuildVersion.contains(upgradeHistories.getName())) {
                UpgradeHistory lastVersion = (UpgradeHistory)CoreObjectManager.getInstance().getManager(UpgradeHistory.class).create();
                lastVersion.setUpgradeDatetime(Timestamp.valueOf(LocalDateTime.now()));
                lastVersion.setName(currentBuildVersion);
                lastVersion.store();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCurrentBuildVersion() {
        String filename = "./buildVersion.properties";
        try (FileInputStream inFile = new FileInputStream(filename);){
            byte[] str = new byte[inFile.available()];
            if (inFile.read(str) >= 1) return new String(str, StandardCharsets.UTF_8);
            log.warn("File {} is empty, or EOF was reached suddenly", (Object)filename);
            String string = null;
            return string;
        }
        catch (IOException | NullPointerException | SecurityException e) {
            log.error("Error while getting current build version", (Throwable)e);
            return null;
        }
    }

    public UiContextListener(ApplicationContext myContext, LockManager lockManager) {
        this.myContext = myContext;
        this.lockManager = lockManager;
    }
}

