/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.service;

import java.time.LocalDateTime;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.hibernate.spring.managers.reports.TcContextObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class JobRunner {
    private static final Logger log = LoggerFactory.getLogger(JobRunner.class);
    private static final String UTC_TIMEZONE = "UTC";
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean multiTenancyEnabled;
    private TcContextObjectManager tcContextObjectManager;

    @Autowired
    public JobRunner(TcContextObjectManager tcContextObjectManager) {
        this.tcContextObjectManager = tcContextObjectManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="${atp-reporting.cron.expression}", zone="UTC")
    @SchedulerLock(name="${atp-reporting.job.name}", lockAtMostFor="5m")
    public void run() {
        log.info("Schedule task start execute at {}", (Object)LocalDateTime.now());
        try {
            if (this.multiTenancyEnabled.booleanValue()) {
                for (String tenantId : TenantContext.getTenantIds((boolean)true)) {
                    TenantContext.setTenantInfo((String)tenantId);
                    int contextCount = 0;
                    log.info("Schedule task: Updated {} context(s) status for projectUuid {}", (Object)contextCount, (Object)tenantId);
                }
                TenantContext.setDefaultTenantInfo();
            }
            int contextCount = 0;
            log.info("Schedule task: Updated {} context(s) status", (Object)contextCount);
        }
        catch (Exception e) {
            log.error("Error while executing a scheduled task {}, message: {}", (Object)LocalDateTime.now(), (Object)e.getMessage());
        }
        finally {
            log.info("Schedule task finish execute at {}", (Object)LocalDateTime.now());
        }
    }
}

