/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MdcHelper {
    private static final Logger log = LoggerFactory.getLogger(MdcHelper.class);

    public void fillMdsFields(JsonObject json) {
        JsonElement objectType = json.get("objectType");
        if (Objects.isNull(objectType) || objectType.getAsString().isEmpty()) {
            log.error("Can't get 'objectType' element value from json object to fill MDC fields.");
            return;
        }
        String type = objectType.getAsString();
        try {
            if ("Combined_TcContext_Initiator".equals(type)) {
                JsonElement tcContextObject = json.get("TcContext");
                if (tcContextObject.isJsonObject()) {
                    MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)tcContextObject.getAsJsonObject().get("id").getAsString());
                }
            } else if ("Combined_StepInstance_SituationInstance".equals(type)) {
                this.fillFromJson(json.getAsJsonObject("StepInstance"));
            } else if ("Combined_SituationInstance_StepInstances".equals(type)) {
                this.fillFromJson(json.getAsJsonObject("SituationInstance"));
            } else if ("combinedFastStubMessage".equals(type)) {
                MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (String)json.get("X-Project-Id").getAsString());
            } else if ("TcContext".equals(type)) {
                MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)json.get("id").getAsString());
            } else {
                if ("CallChainInstance".equals(type)) {
                    MdcUtils.put((String)MdcField.CALL_CHAIN_ID.toString(), (String)json.get("testCaseId").getAsString());
                }
                this.fillFromJson(json);
            }
        }
        catch (Exception e) {
            log.error("Error processing message to fill MDC fields.", (Throwable)e);
        }
    }

    private void fillFromJson(JsonObject jsonObject) {
        JsonObject context = jsonObject.getAsJsonObject("context");
        MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)context.get("tc").getAsString());
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (String)context.get("projectUuid").getAsString());
    }
}

