/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.report.processor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.SQLException;
import java.util.Objects;
import org.qubership.automation.itf.report.processor.AbstractProcessor;
import org.qubership.automation.itf.report.processor.ExecutionReportQueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExecutionReportProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(ExecutionReportProcessor.class);
    private final ExecutionReportQueryExecutor queryExecutor;

    @Override
    protected void process(JsonObject jsonObject) throws SQLException {
        String type = jsonObject.get("objectType").getAsString();
        this.queryExecutor.getStorageByType(type).store(jsonObject, this.queryExecutor);
        this.logIfDebug(jsonObject);
    }

    private void logIfDebug(JsonObject jsonObject) {
        if (!log.isDebugEnabled()) {
            return;
        }
        JsonElement jsonId = jsonObject.get("id");
        JsonElement jsonName = jsonObject.get("name");
        if (Objects.nonNull(jsonId) && Objects.nonNull(jsonName)) {
            log.debug("Processed event, id {}, name {}", (Object)(jsonId.isJsonNull() ? "null" : jsonId.getAsString()), (Object)(jsonName.isJsonNull() ? "null" : jsonName.getAsString()));
        }
    }

    public ExecutionReportProcessor(ExecutionReportQueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }
}

