/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.service.metric;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.function.Supplier;
import org.qubership.automation.itf.ui.service.metric.Metric;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.stereotype.Service;

@Service
public class MetricsAggregateService {
    @Value(value="${message-broker.reports.queue}")
    private String destinationQueueName;
    private final ApplicationContext applicationContext;
    private DefaultMessageListenerContainer defaultMessageListenerContainer;
    private final JmsListenerEndpointRegistry jmsListenerEndpointRegistry;
    private final MeterRegistry meterRegistry;

    @Autowired
    public MetricsAggregateService(ApplicationContext applicationContext, MeterRegistry meterRegistry, JmsListenerEndpointRegistry jmsListenerEndpointRegistry) {
        this.applicationContext = applicationContext;
        this.jmsListenerEndpointRegistry = jmsListenerEndpointRegistry;
        this.meterRegistry = meterRegistry;
    }

    @EventListener
    public void init(ContextRefreshedEvent event) {
        if (event.getSource().equals(this.applicationContext)) {
            this.contextInitialized();
            this.fillJmsListenerStatsMetric();
        }
    }

    private void contextInitialized() {
        for (MessageListenerContainer messageListenerContainer : this.jmsListenerEndpointRegistry.getListenerContainers()) {
            if (!this.destinationQueueName.equals(((DefaultMessageListenerContainer)messageListenerContainer).getDestinationName())) continue;
            this.defaultMessageListenerContainer = (DefaultMessageListenerContainer)messageListenerContainer;
            break;
        }
    }

    private void fillJmsListenerStatsMetric() {
        this.initializeGauges(Metric.ATP_ITF_REPORTING_JMS_LISTENER_THREAD_POOL_ACTIVE_SIZE, () -> this.defaultMessageListenerContainer.getActiveConsumerCount());
        this.initializeGauges(Metric.ATP_ITF_REPORTING_JMS_LISTENER_THREAD_POOL_MAX_SIZE, () -> this.defaultMessageListenerContainer.getMaxConcurrentConsumers());
    }

    private void initializeGauges(Metric metric, Supplier<Number> supplier) {
        Gauge.builder((String)metric.getValue(), supplier).register(this.meterRegistry);
    }
}

