/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.config.jms.connection;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;

@Configuration
@EnableJms
public class ActiveMqConnectionFactoryConfiguration {
    @Value(value="${message-broker.url}")
    private String brokerUrl;
    @Value(value="${receiver.prefetchPolicy.queue}")
    private Integer queuePrefetch;
    @Value(value="${receiver.prefetchPolicy.topic}")
    private Integer topicPrefetch;
    @Value(value="${receiver.redeliveryPolicy.maximumRedeliveries}")
    private Integer maximumRedeliveries;

    @Bean
    public ActiveMQConnectionFactory activeMqConnectionFactory() {
        ActiveMQConnectionFactory activeMqConnectionFactory = new ActiveMQConnectionFactory();
        activeMqConnectionFactory.getPrefetchPolicy().setQueuePrefetch(this.queuePrefetch.intValue());
        activeMqConnectionFactory.getPrefetchPolicy().setTopicPrefetch(this.topicPrefetch.intValue());
        activeMqConnectionFactory.getRedeliveryPolicy().setMaximumRedeliveries(this.maximumRedeliveries.intValue());
        activeMqConnectionFactory.setBrokerURL(this.brokerUrl);
        activeMqConnectionFactory.setMaxThreadPoolSize(100);
        return activeMqConnectionFactory;
    }
}

