/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.report.statement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.qubership.automation.itf.report.statement.Setter;

public abstract class AbstractSetter
implements Setter {
    protected final String property;
    protected final int sqlType;

    protected AbstractSetter(String property, int sqlType) {
        this.property = property;
        this.sqlType = sqlType;
    }

    @Override
    public int set(JsonObject json, PreparedStatement statement, int index) throws SQLException {
        Optional value = this.getValid(json).transform((Function)new Function<JsonElement, Object>(){

            public Object apply(JsonElement input) {
                return AbstractSetter.this.convertJsonValue(input);
            }
        });
        statement.setObject(index, value.orNull(), this.sqlType);
        return ++index;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    protected Optional<? extends JsonElement> getValid(JsonObject json) {
        JsonElement element = json.get(this.property);
        if (element == null || element.isJsonNull()) {
            return Optional.absent();
        }
        return Optional.of((Object)element);
    }

    protected abstract Object convertJsonValue(JsonElement var1);
}

