/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.aspects;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.annotation.Aspect;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.slf4j.LoggerFactory;

@Aspect
public class TransactionAspect
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        return TxExecutor.execute(() -> {
            try {
                return methodInvocation.proceed();
            }
            catch (Throwable throwable) {
                LoggerFactory.getLogger(TransactionAspect.class).error("Failed to execute Tx method", throwable);
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new Exception(throwable);
            }
        });
    }
}

