/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ContextManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.MonitoringManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.reports.TcContextBriefInfoObjectManager;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContextBriefInfo;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.exceptions.ContextNotFoundException;
import org.qubership.automation.itf.exceptions.IncorrectParameterFormatException;
import org.qubership.automation.itf.report.model.ReportObject;
import org.qubership.automation.itf.ui.messages.UIIds;
import org.qubership.automation.itf.ui.messages.monitoring.UIGetReportList;
import org.qubership.automation.itf.ui.messages.objects.UIContextErrors;
import org.qubership.automation.itf.ui.messages.objects.UIReportItem;
import org.qubership.automation.itf.ui.tree.TreeNode;
import org.qubership.automation.itf.ui.tree.TreeNodeTypes;
import org.qubership.automation.itf.ui.tree.TreeNodeUtils;
import org.qubership.automation.itf.util.Maps2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
public class MonitoringController {
    private static final Logger log = LoggerFactory.getLogger(MonitoringController.class);
    private static final String DATE_FORMAT = Config.getConfig().getString("log.appender.date.format");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern(DATE_FORMAT).withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yy HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    private static final String DATE_CONDITIONS_FORMAT = "dd.MM.yy";
    private static final String DURATION_CONDITIONS_FORMAT = "HH:mm:ss";
    private Environment env;
    private final LoadingCache<String, String> urls = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(@NotNull String key) {
            return MonitoringController.this.env.getProperty(key);
        }
    });

    @Autowired
    public void setEnv(Environment env) {
        this.env = env;
    }

    private static UIReportItem buildUIReportItem(TcContextBriefInfo item) {
        UIReportItem uiReportItem = new UIReportItem();
        uiReportItem.setId(item.getID().toString());
        uiReportItem.setName(item.getName());
        uiReportItem.setEnvironment(item.getEnvname() != null ? item.getEnvname().replaceAll("\"", "") : "Environment not set");
        uiReportItem.setSystem(item.getSystemName() != null ? item.getSystemName().replaceAll("\"", "") : "System not set");
        uiReportItem.setOperation(item.getOperationName() != null ? item.getOperationName().replaceAll("\"", "") : "Operation not set");
        uiReportItem.setInitiator(item.getInitiator() != null ? item.getIniname() : "Initiator not set");
        uiReportItem.setInitiatorType(item.getInitiatortype() != null ? item.getInitiatortype() : "Initiator type not set");
        uiReportItem.setStatus(item.getStatus().toString());
        uiReportItem.setStartTime(item.getStartTime() == null ? "" : item.getStartTime().toInstant().atZone(ZoneId.systemDefault()).format(DATE_FORMATTER));
        uiReportItem.setEndTime(item.getEndTime() == null ? "" : item.getEndTime().toInstant().atZone(ZoneId.systemDefault()).format(DATE_FORMATTER));
        uiReportItem.setDuration(MonitoringController.computeAndFormatDuration(item.getDuration(), item.getStartTime(), item.getEndTime()));
        uiReportItem.setClient(item.getClient());
        uiReportItem.setPartNum(item.getPartNum());
        return uiReportItem;
    }

    private static String computeAndFormatDuration(Long duration, Date startTime, Date endTime) {
        long computedDuration;
        if (duration != null) {
            computedDuration = duration;
        } else if (startTime != null) {
            computedDuration = (endTime == null ? new Date().getTime() : endTime.getTime()) - startTime.getTime();
        } else {
            return "";
        }
        return DurationFormatUtils.formatDuration((long)computedDuration, (String)DURATION_CONDITIONS_FORMAT, (boolean)true);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'READ')")
    @RequestMapping(value={"/monitoring/all"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get 1st page of Monitoring data (page size {{#pageSize}}) in the project {{#projectId}}/{{#projectUuid}}")
    public UIGetReportList getPage(@RequestParam BigInteger projectId, @RequestParam(value="projectUuid", required=false) UUID projectUuid, @RequestParam(required=false, defaultValue="20") int pageSize) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        return this.getPage(0, pageSize, false, "", "", "", "", "", "", "", "", "", "", "", "", false, projectId, projectUuid);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'READ')")
    @RequestMapping(value={"/monitoring/page"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get #{{#page}} page of Monitoring data (page size {{#pageSize}}) in the project {{#projectId}}/{{#projectUuid}}. Search conditions: name {{#name}}, initiator {{#initiator}}, status {{#status}}, environment {{#environment}}, startDate {{#startDate}}, startDateCondition {{#startDateCondition}}, finishDate {{#finishDate}}, finishDateCondition {{#finishDateCondition}}, duration {{#duration}}, durationCondition {{#durationCondition}}, client {{#client}}, sortProperty {{#sortProperty}}")
    public UIGetReportList getPage(@RequestParam int page, @RequestParam(required=false, defaultValue="20") int pageSize, @RequestParam(required=false, defaultValue="false") boolean search, @RequestParam(required=false) String name, @RequestParam(required=false) String initiator, @RequestParam(required=false) String status, @RequestParam(required=false) String environment, @RequestParam(required=false) String startDate, @RequestParam(required=false) String startDateCondition, @RequestParam(required=false) String finishDate, @RequestParam(required=false) String finishDateCondition, @RequestParam(required=false) String duration, @RequestParam(required=false) String durationCondition, @RequestParam(required=false) String client, @RequestParam(required=false) String sortProperty, @RequestParam(required=false, defaultValue="false") boolean sortOrder, @RequestParam BigInteger projectId, @RequestParam(value="projectUuid", required=false) UUID projectUuid) {
        Page curPage;
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        UIGetReportList uiReportList = new UIGetReportList();
        if (search) {
            Date stDate = this.checkDateParameter(startDate, "Start date");
            Date finDate = this.checkDateParameter(finishDate, "Finish date");
            Long durate = MonitoringController.checkLongParameter(duration, "Duration");
            curPage = TcContextBriefInfoObjectManager.getPageByFilter((int)pageSize, (int)page, (boolean)Boolean.TRUE, (String)name, (String)initiator, (String)status, (String)environment, (Date)stDate, (String)startDateCondition, (Date)finDate, (String)finishDateCondition, (Long)durate, (String)durationCondition, (String)client, (String)sortProperty, (boolean)sortOrder, (BigInteger)projectId);
        } else {
            curPage = TcContextBriefInfoObjectManager.getPage((int)pageSize, (int)page, (BigInteger)projectId);
        }
        ArrayList<UIReportItem> uiReportItems = new ArrayList<UIReportItem>();
        for (TcContextBriefInfo context : curPage.getContent()) {
            UIReportItem uiReportItem = MonitoringController.buildUIReportItem(context);
            uiReportItems.add(uiReportItem);
        }
        uiReportList.setReportItems(uiReportItems);
        uiReportList.setTotalItems(curPage.getTotalElements());
        uiReportList.setTotalPages(curPage.getTotalPages());
        return uiReportList;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'READ')")
    @RequestMapping(value={"/monitoring/simpleSearch"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get simple Monitoring search results, parameters: initiator {{#initiator}}, status {{#status}}, environment {{#environment}}, minStartDate {{#minStartDate}}, maxStartDate {{#maxStartDate}} in the project {{#projectUuid}}")
    public List<UIReportItem> simpleSearch(@RequestParam String initiator, @RequestParam String status, @RequestParam String environment, @RequestParam String minStartDate, @RequestParam String maxStartDate, @RequestParam(value="projectUuid", required=false) UUID projectUuid) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        Date minStDate = this.checkDateParameter(minStartDate, "Start date");
        Date maxStDate = this.checkDateParameter(maxStartDate, "Finish date");
        Iterable tcc = TcContextBriefInfoObjectManager.simpleSearch((String)initiator, (String)status, (String)environment, (Date)minStDate, (Date)maxStDate);
        ArrayList<UIReportItem> uiReportItems = new ArrayList<UIReportItem>();
        for (TcContextBriefInfo context : tcc) {
            uiReportItems.add(MonitoringController.buildUIReportItem(context));
        }
        return uiReportItems;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'EXECUTE')")
    @RequestMapping(value={"/monitoring/deleteContextsByFilter"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Delete Monitoring data by conditions: name {{#name}}, initiator {{#initiator}}, status {{#status}}, environment {{#environment}}, startDate {{#startDate}}, startDateCondition {{#startDateCondition}}, finishDate {{#finishDate}}, finishDateCondition {{#finishDateCondition}}, duration {{#duration}}, durationCondition {{#durationCondition}}, client {{#client}} in the project {{#projectId}}/{{#projectUuid}}")
    public int deleteByFilter(@RequestParam String name, @RequestParam String initiator, @RequestParam String status, @RequestParam String environment, @RequestParam String startDate, @RequestParam String startDateCondition, @RequestParam String finishDate, @RequestParam String finishDateCondition, @RequestParam(required=false) String duration, @RequestParam(required=false) String durationCondition, @RequestParam(required=false) String client, @RequestParam BigInteger projectId, @RequestParam(value="projectUuid", required=false) UUID projectUuid) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        Date stDate = this.checkDateParameter(startDate, "Start date");
        Date finDate = this.checkDateParameter(finishDate, "Finish date");
        Long durate = MonitoringController.checkLongParameter(duration, "Duration");
        ContextManager manager = (ContextManager)CoreObjectManager.getInstance().getSpecialManager(TcContext.class, ContextManager.class);
        Iterable tcc = TcContextBriefInfoObjectManager.findByFilter((String)name, (String)initiator, (String)status, (String)environment, (Date)stDate, (String)startDateCondition, (Date)finDate, (String)finishDateCondition, (Long)durate, (String)durationCondition, (String)client, (BigInteger)projectId);
        Iterator iterator = tcc.iterator();
        int deletedCount = 0;
        while (iterator.hasNext()) {
            TcContextBriefInfo item = (TcContextBriefInfo)iterator.next();
            manager.deleteById(item.getID().toString(), item.getPartNum());
            ++deletedCount;
        }
        return deletedCount;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'READ')")
    @RequestMapping(value={"/monitoring/get"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Tc-context by id {{#id}} in the project {{#projectId}}/{{#projectUuid}}")
    @ResponseBody
    public UIReportItem getItem(@RequestParam String id, @RequestParam(value="projectUuid") UUID projectUuid, @RequestParam BigInteger projectId, @RequestParam(value="standalone", defaultValue="false") boolean standalone, @RequestParam(required=false) Integer partNum) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)id);
        TcContextBriefInfo briefInfo = ((MonitoringManager)CoreObjectManager.getInstance().getSpecialManager(InstanceContext.class, MonitoringManager.class)).getTcContextInformation(id, partNum);
        if (Objects.isNull(briefInfo)) {
            throw new ContextNotFoundException(id);
        }
        UIReportItem item = MonitoringController.buildUIReportItem(briefInfo);
        MonitoringController.setExtraProperties(item, briefInfo);
        HashMap reportLinks = ((MonitoringManager)CoreObjectManager.getInstance().getSpecialManager(InstanceContext.class, MonitoringManager.class)).getTcContextReportLinks(id, briefInfo.getPartNum());
        this.replaceReportLinks(reportLinks, standalone, projectUuid, projectId);
        item.setReportLinks(reportLinks);
        item.setReportSituations(((MonitoringManager)CoreObjectManager.getInstance().getSpecialManager(InstanceContext.class, MonitoringManager.class)).getTcContextStepsSituations(id, briefInfo.getPartNum()));
        item.setBindingKeys(((MonitoringManager)CoreObjectManager.getInstance().getSpecialManager(InstanceContext.class, MonitoringManager.class)).getTcContextBindingKeys(id, briefInfo.getPartNum()));
        if (briefInfo.getInitiatortype() != null && briefInfo.getInitiatortype().equals("CallChainInstance")) {
            item.setCallchainExecutionData(briefInfo.getExecutiondata());
        }
        return item;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'READ')")
    @RequestMapping(value={"/monitoring/getContextVariables"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Context variables of tc-context id {{#id}} in the project {{#projectUuid}}")
    public UIReportItem getContextVariables(@RequestParam(defaultValue="0") String id, @RequestParam(value="projectUuid", required=false) UUID projectUuid, @RequestParam Integer partNum) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)id);
        UIReportItem uiReportItem = new UIReportItem();
        String contextVariables = ((MonitoringManager)CoreObjectManager.getInstance().getSpecialManager(InstanceContext.class, MonitoringManager.class)).getContextVariables(id, partNum);
        uiReportItem.setContextVariable(contextVariables);
        return uiReportItem;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'READ')")
    @RequestMapping(value={"/monitoring/getContextErrors"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Context errors of tc-context id {{#id}} in the project {{#projectUuid}}")
    public UIContextErrors getContextErrors(@RequestParam(defaultValue="0") String id, @RequestParam(value="projectUuid", required=false) UUID projectUuid, @RequestParam Integer partNum) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)id);
        UIContextErrors errors = new UIContextErrors();
        StringBuilder sbErrorName = new StringBuilder();
        StringBuilder sbErrorMessage = new StringBuilder();
        List errorList = ((MonitoringManager)CoreObjectManager.getInstance().getSpecialManager(InstanceContext.class, MonitoringManager.class)).allTcContextInstancesErrors(id, partNum);
        for (Object[] error : errorList) {
            if (error[2] != null || error[3] != null) {
                sbErrorName.append("<b>Instance: ");
                if (error[2] != null) {
                    sbErrorName.append(error[2]);
                }
                if (error[3] != null) {
                    sbErrorName.append(" [").append(error[3]).append("]");
                }
                sbErrorName.append("</b><br>");
            }
            if (error[0] != null) {
                sbErrorName.append(error[0]).append("<br>");
            }
            if (error[1] == null) continue;
            sbErrorMessage.append(error[1]).append("<br>");
        }
        errors.setErrorName(sbErrorName.toString());
        errors.setErrorMessage(sbErrorMessage.toString());
        return errors;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'READ')")
    @RequestMapping(value={"/monitoring/getmessagetree"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Messages Tree of tc-context id {{#id}} in the project {{#projectUuid}}")
    public List<TreeNode> getMessagesTree(@RequestParam(defaultValue="0") String id, @RequestParam(value="projectUuid", required=false) UUID projectUuid, @RequestParam Integer partNum) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)id);
        List<ReportObject> reportObjects = TreeNodeUtils.getReportObjects(((MonitoringManager)CoreObjectManager.getInstance().getSpecialManager(InstanceContext.class, MonitoringManager.class)).getTreeMessagesFromTcContext(id, partNum));
        return TreeNodeUtils.createTreeNodesByReport(reportObjects, TreeNodeTypes.SITUATION_INSTANCE.toString(), TreeNodeTypes.STEP_INSTANCE.toString(), TreeNodeTypes.INCOMING_MESSAGE.toString(), TreeNodeTypes.OUTGOING_MESSAGE.toString());
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'READ')")
    @RequestMapping(value={"/monitoring/getmessageinfo"}, method={RequestMethod.GET}, produces={"application/json"})
    @AuditAction(auditAction="Get Messages Info of tc-context id {{#id}} in the project {{#projectUuid}}")
    @ResponseBody
    public Map<String, Object> getMessageInfo(@RequestParam String id, @RequestParam(value="projectUuid", required=false) UUID projectUuid, @RequestParam Integer partNum) {
        Object stepContext;
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        MonitoringManager specManager = (MonitoringManager)CoreObjectManager.getInstance().getSpecialManager(InstanceContext.class, MonitoringManager.class);
        HashMap errorInfo = specManager.getStepInstanceError(id, partNum);
        String errorName = (String)errorInfo.get("errorName");
        String errorMessage = (String)errorInfo.get("errorMessage");
        if (StringUtils.isBlank((CharSequence)errorName) && !StringUtils.isBlank((CharSequence)errorMessage)) {
            errorName = errorMessage.substring(0, Math.min(30, errorMessage.length())) + "...";
        }
        HashMap<String, Object> mapMessageInfo = new HashMap<String, Object>();
        mapMessageInfo.put("exception", Maps2.map("errorName", errorName).val("errorMessage", errorMessage).build());
        HashMap ids = specManager.getStepInstanceMessageIds(id, partNum);
        HashMap<String, String> messageMap = new HashMap<String, String>();
        Object msgId = ids.get("incomingMessageId");
        if (msgId != null) {
            HashMap incomingHeaders;
            String incoming = specManager.getMessageText(msgId, partNum);
            messageMap.put("Incoming message", incoming);
            HashMap incomingProps = Maps.newHashMap((Map)specManager.getMessageConnectionProperties(msgId, partNum));
            if (!incomingProps.isEmpty()) {
                mapMessageInfo.put("connectionparameters_incoming", incomingProps);
            }
            if (!(incomingHeaders = Maps.newHashMap((Map)specManager.getMessageHeaders(msgId, partNum))).isEmpty()) {
                mapMessageInfo.put("messageheaders_incoming", incomingHeaders);
            }
        }
        if ((msgId = ids.get("outgoingMessageId")) != null) {
            HashMap outgoingHeaders;
            String outgoing = specManager.getMessageText(msgId, partNum);
            messageMap.put("Outgoing message", outgoing);
            HashMap outgoingProps = Maps.newHashMap((Map)specManager.getMessageConnectionProperties(msgId, partNum));
            if (!outgoingProps.isEmpty()) {
                mapMessageInfo.put("connectionparameters_outgoing", outgoingProps);
            }
            if (!(outgoingHeaders = Maps.newHashMap((Map)specManager.getMessageHeaders(msgId, partNum))).isEmpty()) {
                mapMessageInfo.put("messageheaders_outgoing", outgoingHeaders);
            }
        }
        if ((stepContext = ids.get("stepContext")) != null) {
            mapMessageInfo.put("stepContext", stepContext.toString());
        }
        mapMessageInfo.put("message", messageMap);
        Object spContextId = ids.get("spContextId");
        if (spContextId != null) {
            String validationResults = specManager.getValidationResults(spContextId, partNum);
            mapMessageInfo.put("validation_results", validationResults);
            HashMap spMessageParameters = Maps.newHashMap((Map)specManager.getSpMessageParameters(spContextId, partNum));
            if (!spMessageParameters.isEmpty()) {
                mapMessageInfo.put("messageparameters", spMessageParameters);
            }
        }
        return mapMessageInfo;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'EXECUTE')")
    @RequestMapping(value={"/monitoring/deleteSelectedContexts"}, method={RequestMethod.DELETE})
    @AuditAction(auditAction="Delete selected contexts from project {{#projectUuid}}")
    public void delete(@RequestBody UIIds uiDeleteObjectReq, @RequestParam(value="projectUuid", required=false) UUID projectUuid) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        ContextManager manager = (ContextManager)CoreObjectManager.getInstance().getSpecialManager(TcContext.class, ContextManager.class);
        for (String id : uiDeleteObjectReq.getIds()) {
            manager.deleteById(id, null);
        }
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'READ')")
    @RequestMapping(value={"/monitoring/report"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Monitoring report with parameters: name {{#name}}, initiator {{#initiator}}, status {{#status}}, environment {{#environment}}, startDate {{#startDate}}, startDateCondition {{#startDateCondition}}, finishDate {{#finishDate}}, finishDateCondition {{#finishDateCondition}}, duration {{#duration}}, durationCondition {{#durationCondition}}, client {{#client}}, sortProperty {{#sortProperty}} in the project {{#projectId}}/{{#projectUuid}}")
    public StringBuilder getReport(@RequestParam(required=false) String name, @RequestParam(required=false) String initiator, @RequestParam(required=false) String status, @RequestParam(required=false) String environment, @RequestParam(required=false) String startDate, @RequestParam(required=false) String startDateCondition, @RequestParam(required=false) String finishDate, @RequestParam(required=false) String finishDateCondition, @RequestParam(required=false) String duration, @RequestParam(required=false) String durationCondition, @RequestParam(required=false) String client, @RequestParam(required=false) String sortProperty, @RequestParam(defaultValue="false", required=false) boolean sortOrder, @RequestParam(value="standalone", defaultValue="false") boolean standalone, @RequestParam BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        return this.get_Report(name, initiator, status, environment, startDate, startDateCondition, finishDate, finishDateCondition, duration, durationCondition, client, sortProperty, sortOrder, standalone, projectId, projectUuid);
    }

    private StringBuilder get_Report(String name, String initiator, String status, String environment, String startDate, String startDateCondition, String finishDate, String finishDateCondition, String duration, String durationCondition, String client, String sortProperty, boolean sortOrder, boolean standalone, BigInteger projectId, UUID projectUuid) {
        String escName = StringEscapeUtils.escapeHtml4((String)name);
        String escInitiator = StringEscapeUtils.escapeHtml4((String)initiator);
        String escStatus = StringEscapeUtils.escapeHtml4((String)status);
        String escEnvironment = StringEscapeUtils.escapeHtml4((String)environment);
        String escStartDateCondition = StringEscapeUtils.escapeHtml4((String)startDateCondition);
        String escFinishDateCondition = StringEscapeUtils.escapeHtml4((String)finishDateCondition);
        String escDuration = StringEscapeUtils.escapeHtml4((String)duration);
        String escDurationCondition = StringEscapeUtils.escapeHtml4((String)durationCondition);
        String escClient = StringEscapeUtils.escapeHtml4((String)client);
        String escSortProperty = StringEscapeUtils.escapeHtml4((String)sortProperty);
        Date stDate = this.checkDateParameter(startDate, "Start date");
        Date finDate = this.checkDateParameter(finishDate, "Finish date");
        Long durate = MonitoringController.checkLongParameter(escDuration, "Duration");
        Iterable curPage = TcContextBriefInfoObjectManager.getReportByFilter((String)escName, (String)escInitiator, (String)escStatus, (String)escEnvironment, (Date)stDate, (String)escStartDateCondition, (Date)finDate, (String)escFinishDateCondition, (Long)durate, (String)escDurationCondition, (String)escClient, (String)escSortProperty, (boolean)sortOrder, (BigInteger)projectId);
        StringBuilder conditionForGeneratingReport = MonitoringController.getConditionForGeneratingReport(escName, escInitiator, escStatus, escEnvironment, stDate, escStartDateCondition, finDate, escFinishDateCondition, escDuration, escDurationCondition, escClient, escSortProperty);
        StringBuilder htmlReport = new StringBuilder();
        htmlReport.append("<!DOCTYPE html><html><head><title>ITF validations report</title><style> .EXTRA {background-color:orange;} .SIMILAR {color: #000000;background-color: #FFFF77;} .BROKEN_STEP_INDEX {background-color:yellow;color:red} .MODIFIED {background-color:#ff9999;} .MISSED {background-color:#C7EDFC;}. ERROR {background-color:yellow;color:red} .EMPTY_ROW {background: lightgrey;}</style></head><body><h4>ITF validations report (generated at ").append(new Date(System.currentTimeMillis()).toInstant().atZone(ZoneId.systemDefault()).format(DATE_FORMATTER)).append(")</h4><table style=\"width: 100%; border-collapse: collapse; margin-left: auto; ").append("margin-right: auto;\" border=\"1\"><thead><tr>").append("<th style=\"width: auto%;\">&#8470;</th>").append("<th style=\"width: auto%;\">Name</th>").append("<th style=\"width: auto%;\">Initiator</th>").append("<th style=\"width: auto%;\">Status</th>").append("<th style=\"width: auto%;\">BV Param</th>").append("<th style=\"width: auto%;\">BV Status</th>").append("<th style=\"width: auto%;\">ER</th>").append("<th style=\"width: auto%;\">AR</th>").append("<th style=\"width: auto%;\">Environment</th>").append("<th style=\"width: auto%;\">Start</th>").append("<th style=\"width: auto%;\">Finish</th>").append("<th style=\"width: auto%;\">Duration</th>").append("<th style=\"width: auto%;\">Client</th>").append("</tr></thead><tbody>");
        int count = 0;
        String linkPrefix = this.composeLinkToObject(projectId, projectUuid, "", "#/context/", standalone);
        for (TcContextBriefInfo context : curPage) {
            List errorList;
            String stat = context.getStatus().toString();
            if (stat.equals("Stopped")) continue;
            StringBuilder bvParam = new StringBuilder();
            StringBuilder bvStatus = new StringBuilder();
            StringBuilder expectedValueBv = new StringBuilder();
            StringBuilder actualValueBv = new StringBuilder();
            if (!stat.equals("Passed") && !(errorList = ((MonitoringManager)CoreObjectManager.getInstance().getSpecialManager(InstanceContext.class, MonitoringManager.class)).allTcContextInstancesErrors(context.getID().toString(), context.getPartNum())).isEmpty()) {
                Object[] objects = (Object[])errorList.get(0);
                if (objects[1] == null) continue;
                String htmlString = "<!DOCTYPE html><html><head><title>To parse via JSoup</title></head><body>" + objects[1] + "</body></html>";
                Document html = Jsoup.parse((String)htmlString);
                Elements panelHeadings = html.body().getElementsByAttributeValue("class", "panel-heading");
                for (int i = 0; i < panelHeadings.size(); ++i) {
                    Element element = (Element)panelHeadings.get(i);
                    String statusBv = ((Element)element.getElementsByTag("span").get(0)).className();
                    if ("IDENTICAL".equals(statusBv)) continue;
                    String paramBv = element.ownText();
                    Elements tdElements = ((Element)html.body().getElementsByAttributeValue("style", "vertical-align: top;").get(i)).getElementsByTag("td");
                    MonitoringController.processDiffs((Element)tdElements.get(0), expectedValueBv);
                    MonitoringController.processDiffs((Element)tdElements.get(1), actualValueBv);
                    bvParam.append("<span>").append(paramBv).append("</span><br>");
                    bvStatus.append("<span>").append(statusBv).append("</span><br>");
                }
            }
            String color = stat.equalsIgnoreCase("Passed") ? "#dff0d8;" : (stat.equalsIgnoreCase("Failed") || stat.equalsIgnoreCase("Failed by timeout") ? "#f2dede" : "#ffffff");
            htmlReport.append("<tr style=\"background: ").append(color).append("\"> <td>").append(++count).append("</td>");
            htmlReport.append("<td style=\"text-align: left;\"><a href=\"").append(linkPrefix).append(context.getID()).append("\" target=\"_blank\">").append(context.getName()).append("</a></td>");
            htmlReport.append("<td style=\"text-align: left;\">").append(context.getInitiator() != null ? context.getIniname() : "Initiator not set").append("</td>");
            htmlReport.append("<td style=\"text-align: center;\"><span>").append(context.getStatus()).append("</span></td>");
            htmlReport.append("<td style=\"text-align: center;\">").append((CharSequence)bvParam).append("</td>");
            htmlReport.append("<td style=\"text-align: center;\">").append((CharSequence)bvStatus).append("</td>");
            htmlReport.append("<td style=\"text-align: left; vertical-align: top; background: white;\">").append((CharSequence)expectedValueBv).append("</td>");
            htmlReport.append("<td style=\"text-align: left; vertical-align: top; background: white;\">").append((CharSequence)actualValueBv).append("</td>");
            htmlReport.append("<td>").append(context.getEnvironment() != null ? context.getEnvname() : "Environment not set").append("</td>");
            htmlReport.append("<td>").append(context.getStartTime() == null ? "" : context.getStartTime().toInstant().atZone(ZoneId.systemDefault()).format(DATE_FORMATTER)).append("</td>");
            htmlReport.append("<td>").append(context.getEndTime() == null ? "" : context.getEndTime().toInstant().atZone(ZoneId.systemDefault()).format(DATE_FORMATTER)).append("</td>");
            htmlReport.append("<td>").append(context.getDuration() == null ? "" : DurationFormatUtils.formatDuration((long)context.getDuration(), (String)DURATION_CONDITIONS_FORMAT, (boolean)true)).append("</td>");
            htmlReport.append("<td>").append(context.getClient() == null ? "" : context.getClient()).append("</td></tr>");
        }
        htmlReport.append("</tbody></table><h4>Total:").append(count).append("</h4><div>Report conditions & sorting: ").append((CharSequence)conditionForGeneratingReport).append("</div></body></html>");
        return htmlReport;
    }

    private static void processDiffs(Element highlightedValue, StringBuilder stringValueBv) {
        Elements diffElements = highlightedValue.getElementsByAttributeValueMatching("class", "[^(NORMAL|IDENTICAL)]");
        for (Element value : diffElements) {
            Elements thisChildElement = value.children();
            if (!thisChildElement.isEmpty() && !value.hasText()) continue;
            stringValueBv.append("<nobr>").append(value).append("</nobr><br>");
        }
    }

    private static void setExtraProperties(UIReportItem uiReportItem, TcContextBriefInfo item) {
        if (Objects.isNull(item.getInitiator())) {
            return;
        }
        if (item.getInitiatortype().equals("SituationInstance")) {
            if (Objects.isNull(item.getSituationId())) {
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)item.getOperationName())) {
                uiReportItem.setOperation(item.getOperationName());
            }
            if (StringUtils.isNotEmpty((CharSequence)item.getSystemName())) {
                uiReportItem.setSystem(item.getSystemName());
            }
        } else {
            uiReportItem.setInitiatorId(item.getChainId() != null ? item.getChainId().toString() : "TestCase not set");
        }
    }

    private Date checkDateParameter(String stringValue, String parameterName) throws IncorrectParameterFormatException {
        Date dateValue = null;
        if (stringValue != null && !stringValue.isEmpty()) {
            try {
                String value = stringValue.trim();
                if (value.length() == 8) {
                    value = value + " 00:00:00.000";
                }
                dateValue = Date.from(Instant.from(DATE_TIME_FORMATTER.parse(value)));
            }
            catch (Exception ex) {
                throw new IncorrectParameterFormatException(parameterName, DATE_CONDITIONS_FORMAT, ex.getMessage());
            }
        }
        return dateValue;
    }

    private static Long checkLongParameter(String stringValue, String parameterName) throws IncorrectParameterFormatException {
        Long duration = null;
        if (stringValue != null && !stringValue.isEmpty()) {
            try {
                String[] value = stringValue.trim().split(":");
                duration = ((long)Integer.parseInt(value[0]) * 3600L + (long)Integer.parseInt(value[1]) * 60L + (long)Integer.parseInt(value[2])) * 1000L;
            }
            catch (Exception ex) {
                throw new IncorrectParameterFormatException(parameterName, DURATION_CONDITIONS_FORMAT, ex.getMessage());
            }
        }
        return duration;
    }

    private static StringBuilder getConditionForGeneratingReport(String name, String initiator, String status, String environment, Date startDate, String startDateCondition, Date finishDate, String finishDateCondition, String duration, String durationCondition, String client, String sortProperty) throws IllegalArgumentException {
        StringBuilder conditionForGeneratingReport = new StringBuilder();
        conditionForGeneratingReport.append(StringUtils.isBlank((CharSequence)name) ? "" : "name - " + name + ", ");
        conditionForGeneratingReport.append(StringUtils.isBlank((CharSequence)initiator) ? "" : "initiator - " + initiator + ", ");
        conditionForGeneratingReport.append(StringUtils.isBlank((CharSequence)status) ? "" : "status - " + status + ", ");
        conditionForGeneratingReport.append(StringUtils.isBlank((CharSequence)environment) ? "" : "environment - " + environment + ", ");
        conditionForGeneratingReport.append(Objects.isNull(startDate) ? "" : "start date " + startDateCondition + " " + startDate + ", ");
        conditionForGeneratingReport.append(Objects.isNull(finishDate) ? "" : "finish date " + finishDateCondition + " " + finishDate + ", ");
        conditionForGeneratingReport.append(StringUtils.isBlank((CharSequence)duration) ? "" : "duration " + durationCondition + " " + duration + ", ");
        conditionForGeneratingReport.append(StringUtils.isBlank((CharSequence)client) ? "" : "client - " + client + ", ");
        conditionForGeneratingReport.append("sortProperty - ").append(sortProperty);
        return conditionForGeneratingReport;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="In fact, null check is performed in the Objects.requireNonNull enclosing method")
    private void replaceReportLinks(Map<String, String> reportLinks, boolean standalone, UUID projectUuid, BigInteger projectId) {
        if (reportLinks == null || reportLinks.isEmpty() || !standalone || projectUuid == null || projectId == null) {
            return;
        }
        String reg = (String)this.urls.getUnchecked((Object)"atp.catalogue.url") + "/project/" + projectUuid + "/itf";
        String repl = (String)this.urls.getUnchecked((Object)"configurator.url") + "/project/" + projectId;
        for (Map.Entry<String, String> reportLink : reportLinks.entrySet()) {
            if (StringUtils.isBlank((CharSequence)reportLink.getKey()) || reportLink.getValue() == null) continue;
            reportLinks.put(reportLink.getKey(), reportLink.getValue().replaceFirst(reg, repl));
        }
    }

    private String composeLinkToObject(BigInteger projectId, UUID projectUuid, Object objectId, String endpoint, boolean standalone) {
        return standalone ? (String)this.urls.getUnchecked((Object)"configurator.url") + "/project/" + projectId + endpoint + objectId : (String)this.urls.getUnchecked((Object)"atp.catalogue.url") + "/project/" + projectUuid + "/itf" + endpoint + objectId;
    }
}

