/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.MonitoringManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.reports.TcContextBriefInfoObjectManager;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ContextService {
    private static final Logger log = LoggerFactory.getLogger(ContextService.class);
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean multiTenancyEnabled;
    public static final ConcurrentHashMap<String, Integer> currentPartitionNumbers = ContextService.initPartitionNumbers();
    private final ScheduledExecutorService refreshPartitionsService = this.initRefreshPartitionsService();

    private ScheduledExecutorService initRefreshPartitionsService() {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleWithFixedDelay(() -> {
            try {
                this.refreshPartitionNumbers(this.getCurrentPartitionNumbers());
            }
            catch (Throwable t) {
                log.error("Error while refreshing of current partition numbers from reporting database(s)", t);
            }
        }, 5L, 3600L, TimeUnit.SECONDS);
        return service;
    }

    private static ConcurrentHashMap<String, Integer> initPartitionNumbers() {
        ConcurrentHashMap<String, Integer> currentPartitionNumbers = new ConcurrentHashMap<String, Integer>();
        currentPartitionNumbers.put("Default", 1);
        return currentPartitionNumbers;
    }

    public static int getCurrentPartitionNumberByProject(UUID projectUuid) {
        Integer i = currentPartitionNumbers.get(projectUuid.toString());
        return i == null ? currentPartitionNumbers.get("Default").intValue() : i.intValue();
    }

    public static int getCurrentPartitionNumberByProject(String projectUuid) {
        Integer i = currentPartitionNumbers.get(projectUuid);
        return i == null ? currentPartitionNumbers.get("Default").intValue() : i.intValue();
    }

    public void refreshPartitionNumbers(Map<String, Integer> newData) {
        currentPartitionNumbers.putAll(newData);
    }

    public List<Object[]> getContextProperties(String contextId) {
        return ((MonitoringManager)CoreObjectManager.getInstance().getSpecialManager(InstanceContext.class, MonitoringManager.class)).getTcContextInfo(contextId);
    }

    public String getContextVariables(String contextId) {
        return ((MonitoringManager)CoreObjectManager.getInstance().getSpecialManager(InstanceContext.class, MonitoringManager.class)).getContextVariables(contextId);
    }

    public Set<String> getKeys(String contextId) {
        return ((MonitoringManager)CoreObjectManager.getInstance().getSpecialManager(InstanceContext.class, MonitoringManager.class)).getTcContextBindingKeys(contextId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getCurrentPartitionNumbers() {
        HashMap<String, Integer> currentPartitions = new HashMap<String, Integer>();
        try {
            if (this.multiTenancyEnabled.booleanValue()) {
                for (String tenantId : TenantContext.getTenantIds((boolean)false)) {
                    TenantContext.setTenantInfo((String)tenantId);
                    currentPartitions.put(tenantId, TcContextBriefInfoObjectManager.getCurrentPartitionNumber());
                }
                TenantContext.setDefaultTenantInfo();
            }
            currentPartitions.put("Default", TcContextBriefInfoObjectManager.getCurrentPartitionNumber());
        }
        catch (Exception e) {
            log.error("Error while current partition number getting", (Throwable)e);
        }
        finally {
            TenantContext.setDefaultTenantInfo();
        }
        return currentPartitions;
    }
}

