/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.report.processor;

import com.google.gson.JsonObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.qubership.automation.itf.core.util.logger.TimeLogger;
import org.qubership.automation.itf.report.QueryExecutor;
import org.qubership.automation.itf.report.statement.StatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class AbstractQueryExecutor
implements QueryExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQueryExecutor.class);
    private JdbcTemplate jdbcTemplate;

    @Override
    public Object execute(StatementContext sql, JsonObject object, boolean isNeedResultSet) {
        TimeLogger.LOGGER.debug("Start for method: org.qubership.automation.itf.core.report.impl.AbstractQueryExecutor.execute. sql:" + sql.getQuery());
        Object result = this.jdbcTemplate.execute(connection -> sql.prepare(object, connection), preparedStatement -> {
            Object result1 = null;
            if (isNeedResultSet) {
                result1 = this.prepareData(this.insert(preparedStatement), object);
            } else {
                this.update(preparedStatement);
            }
            return result1;
        });
        TimeLogger.LOGGER.debug("End for method: org.qubership.automation.itf.core.report.impl.AbstractQueryExecutor.execute. sql:" + sql.getQuery());
        return result;
    }

    private ResultSet insert(PreparedStatement statement) throws SQLException {
        return statement.executeQuery();
    }

    private void update(PreparedStatement statement) throws SQLException {
        statement.execute();
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    protected abstract Object prepareData(ResultSet var1, JsonObject var2) throws SQLException;
}

