/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.ui.services.ContextService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ContextController {
    private final ContextService contextService;

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'READ')")
    @RequestMapping(value={"/context/getProperties"}, method={RequestMethod.GET}, produces={"application/json"})
    @AuditAction(auditAction="Get Context Properties of tc-context id {{#contextId}} in the project {{#projectUuid}}")
    public List<Object[]> getContextProperties(@RequestParam(value="contextId") String contextId, @RequestParam(required=false) UUID projectUuid) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)contextId);
        return this.contextService.getContextProperties(contextId);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, 'READ')")
    @RequestMapping(value={"/context/getContextVariables"}, method={RequestMethod.GET}, produces={"text/plain"})
    @AuditAction(auditAction="Get Context Variables of tc-context id {{#contextId}} in the project {{#projectUuid}}")
    public String getContextVariables(@RequestParam(value="contextId") String contextId, @RequestParam(required=false) UUID projectUuid) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)contextId);
        return this.contextService.getContextVariables(contextId);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/context/getKeys"}, method={RequestMethod.GET}, produces={"application/json"})
    @AuditAction(auditAction="Get Context Keys of tc-context id {{#contextId}} in the project {{#projectUuid}}")
    public Set<String> getKeys(@RequestParam(value="contextId") String contextId, @RequestParam(required=false) UUID projectUuid) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)contextId);
        return this.contextService.getKeys(contextId);
    }

    @Transactional(readOnly=true)
    @RequestMapping(value={"/partition/current"}, method={RequestMethod.GET})
    public Map<String, Integer> getCurrentPartitionNumbers() {
        return this.contextService.getCurrentPartitionNumbers();
    }

    public ContextController(ContextService contextService) {
        this.contextService = contextService;
    }
}

