/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.crypt.provider;

import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.qubership.atp.crypt.ConverterTools;
import org.qubership.atp.crypt.CryptoTools;
import org.qubership.atp.crypt.KeyPairGenerator;
import org.qubership.atp.crypt.api.CryptoProvider;
import org.qubership.atp.crypt.api.KeyEntity;

public class BouncyCastleProvider
implements CryptoProvider {
    private static final String BC_PROVIDER = "BC";
    private final KeyPairGenerator keyGenerator = new KeyPairGenerator();

    @Override
    public KeyEntity generateKeys() throws Exception {
        return this.keyGenerator.generateKeys();
    }

    @Override
    public Object readPublicKey(String publicKey) throws Exception {
        return this.keyGenerator.readPublicKey(publicKey);
    }

    @Override
    public Object readPrivateKey(String privateKey) throws Exception {
        return this.keyGenerator.readPrivateKey(privateKey);
    }

    @Override
    public Object readKey(String key) throws Exception {
        return this.keyGenerator.readKey(key);
    }

    @Override
    public String encrypt(String transformation, String data, Object key) throws Exception {
        byte[] datas = ConverterTools.stringToBytes(data);
        byte[][] encrypted = this.encrypt(transformation, datas, key);
        return this.addEncryptMarker(ConverterTools.encode(encrypted[0]), ConverterTools.encode(encrypted[1]));
    }

    private byte[][] encrypt(String transformation, byte[] data, Object key) throws Exception {
        Cipher cipher = Cipher.getInstance(transformation, BC_PROVIDER);
        cipher.init(1, (Key)key);
        return new byte[][]{cipher.getIV(), cipher.doFinal(data)};
    }

    @Override
    public boolean isEncrypted(String data) {
        if (data != null) {
            String[] encryptedData = CryptoTools.getEncryptedData(data);
            return encryptedData != null && encryptedData[1] != null && encryptedData[1].length() > 0;
        }
        return false;
    }

    @Override
    public String decrypt(String transformation, String data, Object key) throws Exception {
        if (!this.isEncrypted(data)) {
            throw new IllegalArgumentException("Wrong crypto provider for input encrypted data.");
        }
        String[] encryptedData = CryptoTools.getEncryptedData(data);
        byte[] vector = ConverterTools.decode(encryptedData[0]);
        byte[] datas = ConverterTools.decode(encryptedData[1]);
        byte[] decrypted = this.decrypt(transformation, vector, datas, key);
        return ConverterTools.bytesToString(decrypted);
    }

    private byte[] decrypt(String transformation, byte[] vector, byte[] data, Object key) throws Exception {
        Cipher cipher = Cipher.getInstance(transformation, BC_PROVIDER);
        if (null != vector && vector.length > 0) {
            cipher.init(2, (Key)key, new IvParameterSpec(vector));
        } else {
            cipher.init(2, (Key)key);
        }
        return cipher.doFinal(data);
    }

    private String addEncryptMarker(String vector, String data) {
        return "{ENC}{" + vector + "}{" + data + "}";
    }

    static {
        Provider provider = Security.getProvider(BC_PROVIDER);
        if (provider == null) {
            Security.addProvider((Provider)new org.bouncycastle.jce.provider.BouncyCastleProvider());
        }
    }
}

