/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.datasets.controllers;

import org.qubership.atp.datasets.dto.FileDataDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-19T14:15:27.190Z[Etc/UTC]")
@Validated
@Tag(name = "AttachmentController", description = "Attachment Controller")
public interface AttachmentControllerApi {

    /**
     * DELETE /attachment/attributeId/{attributeId}/dataset/{datasetId} : deleteByAttributeIdAndDatasetId
     *
     * @param attributeId attributeId (required)
     * @param datasetId datasetId (required)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteByAttributeIdAndDatasetId",
        summary = "deleteByAttributeIdAndDatasetId",
        tags = { "attachment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/attachment/attributeId/{attributeId}/dataset/{datasetId}"
    )
    ResponseEntity<Void> deleteByAttributeIdAndDatasetId(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @Parameter(name = "datasetId", description = "datasetId", required = true) @PathVariable("datasetId") UUID datasetId
    );


    /**
     * DELETE /attachment/{parameterUuid} : deleteByParameterId
     *
     * @param parameterUuid parameterUuid (required)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteByParameterId",
        summary = "deleteByParameterId",
        tags = { "attachment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/attachment/{parameterUuid}"
    )
    ResponseEntity<Void> deleteByParameterId(
        @Parameter(name = "parameterUuid", description = "parameterUuid", required = true) @PathVariable("parameterUuid") UUID parameterUuid
    );


    /**
     * GET /attachment/attributeId/{attributeId}/dataset/{datasetId} : getAttachmentByAttributeIdAndDatasetId
     *
     * @param attributeId attributeId (required)
     * @param datasetId datasetId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAttachmentByAttributeIdAndDatasetId",
        summary = "getAttachmentByAttributeIdAndDatasetId",
        tags = { "attachment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/octet-stream", schema = @Schema(implementation = org.springframework.core.io.Resource.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/attachment/attributeId/{attributeId}/dataset/{datasetId}",
        produces = { "application/octet-stream" }
    )
    ResponseEntity<org.springframework.core.io.Resource> getAttachmentByAttributeIdAndDatasetId(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @Parameter(name = "datasetId", description = "datasetId", required = true) @PathVariable("datasetId") UUID datasetId
    );


    /**
     * GET /attachment/{parameterUuid} : getAttachmentByParameterId
     *
     * @param parameterUuid parameterUuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAttachmentByParameterId",
        summary = "getAttachmentByParameterId",
        tags = { "attachment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/octet-stream", schema = @Schema(implementation = org.springframework.core.io.Resource.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/attachment/{parameterUuid}",
        produces = { "application/octet-stream" }
    )
    ResponseEntity<org.springframework.core.io.Resource> getAttachmentByParameterId(
        @Parameter(name = "parameterUuid", description = "parameterUuid", required = true) @PathVariable("parameterUuid") UUID parameterUuid
    );


    /**
     * POST /attachment/attributeId/{attributeId}/dataset/{datasetId} : uploadByAttributeIdAndDatasetId
     *
     * @param attributeId attributeId (required)
     * @param datasetId datasetId (required)
     * @param type type (required)
     * @param fileName fileName (required)
     * @param file file (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or IM Used (status code 226)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "uploadByAttributeIdAndDatasetId",
        summary = "uploadByAttributeIdAndDatasetId",
        tags = { "attachment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = FileDataDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "226", description = "IM Used"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/attachment/attributeId/{attributeId}/dataset/{datasetId}",
        produces = { "application/json" }
    )
    ResponseEntity<FileDataDto> uploadByAttributeIdAndDatasetId(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @Parameter(name = "datasetId", description = "datasetId", required = true) @PathVariable("datasetId") UUID datasetId,
        @NotNull @Parameter(name = "type", description = "type", required = true) @Valid @RequestParam(value = "type", required = true) String type,
        @NotNull @Parameter(name = "fileName", description = "fileName", required = true) @Valid @RequestParam(value = "fileName", required = true) String fileName,
        @NotNull @Parameter(name = "file", description = "file", required = true) @Valid @RequestParam(value = "file", required = true) org.springframework.core.io.Resource file,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * POST /attachment/{parameterUuid} : uploadByParameterId
     *
     * @param parameterUuid parameterUuid (required)
     * @param type type (required)
     * @param fileName fileName (required)
     * @param file file (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "uploadByParameterId",
        summary = "uploadByParameterId",
        tags = { "attachment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = FileDataDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/attachment/{parameterUuid}",
        produces = { "application/json" }
    )
    ResponseEntity<FileDataDto> uploadByParameterId(
        @Parameter(name = "parameterUuid", description = "parameterUuid", required = true) @PathVariable("parameterUuid") UUID parameterUuid,
        @NotNull @Parameter(name = "type", description = "type", required = true) @Valid @RequestParam(value = "type", required = true) String type,
        @NotNull @Parameter(name = "fileName", description = "fileName", required = true) @Valid @RequestParam(value = "fileName", required = true) String fileName,
        @NotNull @Parameter(name = "file", description = "file", required = true) @Valid @RequestParam(value = "file", required = true) org.springframework.core.io.Resource file
    );

}
