/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.datasets.controllers;

import org.qubership.atp.datasets.dto.AttributeCreateResponseDto;
import org.qubership.atp.datasets.dto.AttributeDto;
import org.qubership.atp.datasets.dto.AttributeTypeDto;
import java.util.List;
import org.qubership.atp.datasets.dto.ListValueDto;
import java.util.Map;
import org.qubership.atp.datasets.dto.PairOfUUidAndIntDto;
import java.util.Set;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-19T14:15:27.769Z[Etc/UTC]")
@Validated
@Tag(name = "AttributeController", description = "Attribute Controller")
public interface AttributeControllerApi {

    /**
     * DELETE /attribute/{attributeId}/bulk : Bulk delete list values by id.
     *
     * @param attributeId attributeId (required)
     * @param listValues listValues (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "bulkDeleteListValues",
        summary = "Bulk delete list values by id.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/attribute/{attributeId}/bulk"
    )
    ResponseEntity<Void> bulkDeleteListValues(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @NotNull @Parameter(name = "listValues", description = "listValues", required = true) @Valid @RequestParam(value = "listValues", required = true) UUID listValues,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * PUT /attribute/dsl/{dataSetListId} : Creates new attribute with provided name and order.
     *
     * @param dataSetListId dataSetListId (required)
     * @param name name (required)
     * @param ordering ordering (required)
     * @param type type (required)
     * @param typeDataSetListId typeDataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @param requestBody  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "create",
        summary = "Creates new attribute with provided name and order.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = AttributeCreateResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/attribute/dsl/{dataSetListId}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<AttributeCreateResponseDto> create(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name,
        @NotNull @Parameter(name = "ordering", description = "ordering", required = true) @Valid @RequestParam(value = "ordering", required = true) Integer ordering,
        @NotNull @Parameter(name = "type", description = "type", required = true) @Valid @RequestParam(value = "type", required = true) AttributeTypeDto type,
        @Parameter(name = "typeDataSetListId", description = "typeDataSetListId") @Valid @RequestParam(value = "typeDataSetListId", required = false) UUID typeDataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen,
        @Parameter(name = "request_body", description = "") @Valid @RequestBody(required = false) List<String> requestBody
    );


    /**
     * PUT /attribute/{attributeId}/listValues : Creates new list value for provided attribute.
     *
     * @param attributeId attributeId (required)
     * @param value value (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createListValue",
        summary = "Creates new list value for provided attribute.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ListValueDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/attribute/{attributeId}/listValues",
        produces = { "application/json" }
    )
    ResponseEntity<ListValueDto> createListValue(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @NotNull @Parameter(name = "value", description = "value", required = true) @Valid @RequestParam(value = "value", required = true) String value,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * POST /attribute/{attributeId}/listValues : Creates new list values for provided attribute by text.
     *
     * @param attributeId attributeId (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @param requestBody  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createListValues",
        summary = "Creates new list values for provided attribute by text.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/attribute/{attributeId}/listValues",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<UUID>> createListValues(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen,
        @Parameter(name = "request_body", description = "") @Valid @RequestBody(required = false) List<String> requestBody
    );


    /**
     * DELETE /attribute/{attributeId} : Deletes selected attribute.
     *
     * @param attributeId attributeId (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "delete",
        summary = "Deletes selected attribute.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Boolean.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/attribute/{attributeId}",
        produces = { "application/json" }
    )
    ResponseEntity<Boolean> delete(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * DELETE /attribute/dsl/{dataSetListId}/all : Deletes attributes from the selected dataSetsList.
     *
     * @param dataSetListId dataSetListId (required)
     * @param modifiedWhen modifiedWhen (optional)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteAllByDsl",
        summary = "Deletes attributes from the selected dataSetsList.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/attribute/dsl/{dataSetListId}/all"
    )
    ResponseEntity<Void> deleteAllByDsl(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * DELETE /attribute/{attributeId}/listValues/{listValueId} : Delete list value by id.
     *
     * @param attributeId attributeId (required)
     * @param listValueId listValueId (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteListValue",
        summary = "Delete list value by id.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/attribute/{attributeId}/listValues/{listValueId}"
    )
    ResponseEntity<Void> deleteListValue(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @Parameter(name = "listValueId", description = "listValueId", required = true) @PathVariable("listValueId") UUID listValueId,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * GET /attribute/{attributeId} : Returns attribute.
     *
     * @param attributeId attributeId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "get",
        summary = "Returns attribute.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = AttributeDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/attribute/{attributeId}",
        produces = { "application/json" }
    )
    ResponseEntity<AttributeDto> get(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId
    );


    /**
     * GET /attribute/dsl/{dataSetListId} : Returns all attributes by dataSetList id.
     *
     * @param dataSetListId dataSetListId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAttributes",
        summary = "Returns all attributes by dataSetList id.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = AttributeDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/attribute/dsl/{dataSetListId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<AttributeDto>> getAttributes(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId
    );


    /**
     * GET /attribute/dsl/{dataSetListId}/itf : Returns all attributes by dataSetList id in itf format: [attr1.attr2, attr1].
     *
     * @param dataSetListId dataSetListId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAttributesInItfFormat",
        summary = "Returns all attributes by dataSetList id in itf format: [attr1.attr2, attr1].",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/attribute/dsl/{dataSetListId}/itf",
        produces = { "application/json" }
    )
    ResponseEntity<Object> getAttributesInItfFormat(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId
    );


    /**
     * GET /attribute/{attributeId}/options : getOptions
     *
     * @param attributeId attributeId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getOptions",
        summary = "getOptions",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/attribute/{attributeId}/options",
        produces = { "application/json" }
    )
    ResponseEntity<Object> getOptions(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId
    );


    /**
     * POST /attribute/{dataSetListId}/existedValues : Sort Attribute values.
     *
     * @param dataSetListId dataSetListId (required)
     * @param targetAttrId targetAttrId (required)
     * @param requestBody  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getParametersValuesAndDataSetIdsForAttributeValuesSorting",
        summary = "Sort Attribute values.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = List.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/attribute/{dataSetListId}/existedValues",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<List>> getParametersValuesAndDataSetIdsForAttributeValuesSorting(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @NotNull @Parameter(name = "targetAttrId", description = "targetAttrId", required = true) @Valid @RequestParam(value = "targetAttrId", required = true) UUID targetAttrId,
        @Parameter(name = "request_body", description = "") @Valid @RequestBody(required = false) Map<String, Set<UUID>> requestBody
    );


    /**
     * POST /attribute/{attributeId} : Renames selected attribute.
     *
     * @param attributeId attributeId (required)
     * @param name name (required)
     * @param dataSetListId dataSetListId (optional)
     * @param modifiedWhen modifiedWhen (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "rename",
        summary = "Renames selected attribute.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Boolean.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/attribute/{attributeId}",
        produces = { "application/json" }
    )
    ResponseEntity<Boolean> rename(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name,
        @Parameter(name = "dataSetListId", description = "dataSetListId") @Valid @RequestParam(value = "dataSetListId", required = false) UUID dataSetListId,
        @Parameter(name = "modifiedWhen", description = "modifiedWhen") @Valid @RequestParam(value = "modifiedWhen", required = false) Long modifiedWhen
    );


    /**
     * POST /attribute/{attributeId}/position : Creates new list values for provided attribute by text.
     *
     * @param attributeId attributeId (required)
     * @param body  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "setPosition",
        summary = "Creates new list values for provided attribute by text.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/attribute/{attributeId}/position",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> setPosition(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @Parameter(name = "body", description = "") @Valid @RequestBody(required = false) Integer body
    );


    /**
     * POST /attribute/{attributeId}/dataSetListReference : Update DSL reference.
     *
     * @param attributeId attributeId (required)
     * @param value value (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateDslReference",
        summary = "Update DSL reference.",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Boolean.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/attribute/{attributeId}/dataSetListReference",
        produces = { "application/json" }
    )
    ResponseEntity<Boolean> updateDslReference(
        @Parameter(name = "attributeId", description = "attributeId", required = true) @PathVariable("attributeId") UUID attributeId,
        @Parameter(name = "value", description = "value") @Valid @RequestParam(value = "value", required = false) UUID value
    );


    /**
     * PUT /attribute/updateOrdering : updateOrdering
     *
     * @param pairOfUUidAndIntDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateOrdering",
        summary = "updateOrdering",
        tags = { "attribute-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/attribute/updateOrdering",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> updateOrdering(
        @Parameter(name = "PairOfUUidAndIntDto", description = "") @Valid @RequestBody(required = false) List<PairOfUUidAndIntDto> pairOfUUidAndIntDto
    );

}
