package org.qubership.atp.datasets.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.datasets.dto.AttributeDto;
import org.qubership.atp.datasets.dto.LabelDto;
import org.qubership.atp.datasets.dto.TestPlanDto;
import org.qubership.atp.datasets.dto.VisibilityAreaDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DataSetListDto
 */

@JsonTypeName("DataSetList")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-19T14:15:27.769Z[Etc/UTC]")
public class DataSetListDto {

  @JsonProperty("attributes")
  @Valid
  private List<AttributeDto> attributes = null;

  @JsonProperty("createdBy")
  private UUID createdBy;

  @JsonProperty("createdWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdWhen;

  @JsonProperty("dataSets")
  @Valid
  private List<Object> dataSets = null;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("labels")
  @Valid
  private List<LabelDto> labels = null;

  @JsonProperty("modifiedBy")
  private UUID modifiedBy;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  @JsonProperty("testPlan")
  private TestPlanDto testPlan;

  @JsonProperty("visibilityArea")
  private VisibilityAreaDto visibilityArea;

  public DataSetListDto attributes(List<AttributeDto> attributes) {
    this.attributes = attributes;
    return this;
  }

  public DataSetListDto addAttributesItem(AttributeDto attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

  /**
   * Get attributes
   * @return attributes
  */
  @Valid 
  @Schema(name = "attributes", required = false)
  public List<AttributeDto> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<AttributeDto> attributes) {
    this.attributes = attributes;
  }

  public DataSetListDto createdBy(UUID createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UUID getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UUID createdBy) {
    this.createdBy = createdBy;
  }

  public DataSetListDto createdWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
    return this;
  }

  /**
   * Get createdWhen
   * @return createdWhen
  */
  @Valid 
  @Schema(name = "createdWhen", required = false)
  public OffsetDateTime getCreatedWhen() {
    return createdWhen;
  }

  public void setCreatedWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
  }

  public DataSetListDto dataSets(List<Object> dataSets) {
    this.dataSets = dataSets;
    return this;
  }

  public DataSetListDto addDataSetsItem(Object dataSetsItem) {
    if (this.dataSets == null) {
      this.dataSets = new ArrayList<>();
    }
    this.dataSets.add(dataSetsItem);
    return this;
  }

  /**
   * Get dataSets
   * @return dataSets
  */
  
  @Schema(name = "dataSets", required = false)
  public List<Object> getDataSets() {
    return dataSets;
  }

  public void setDataSets(List<Object> dataSets) {
    this.dataSets = dataSets;
  }

  public DataSetListDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @NotNull @Valid 
  @Schema(name = "id", required = true)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public DataSetListDto labels(List<LabelDto> labels) {
    this.labels = labels;
    return this;
  }

  public DataSetListDto addLabelsItem(LabelDto labelsItem) {
    if (this.labels == null) {
      this.labels = new ArrayList<>();
    }
    this.labels.add(labelsItem);
    return this;
  }

  /**
   * Get labels
   * @return labels
  */
  @Valid 
  @Schema(name = "labels", required = false)
  public List<LabelDto> getLabels() {
    return labels;
  }

  public void setLabels(List<LabelDto> labels) {
    this.labels = labels;
  }

  public DataSetListDto modifiedBy(UUID modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", required = false)
  public UUID getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UUID modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public DataSetListDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public DataSetListDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", required = true)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DataSetListDto testPlan(TestPlanDto testPlan) {
    this.testPlan = testPlan;
    return this;
  }

  /**
   * Get testPlan
   * @return testPlan
  */
  @Valid 
  @Schema(name = "testPlan", required = false)
  public TestPlanDto getTestPlan() {
    return testPlan;
  }

  public void setTestPlan(TestPlanDto testPlan) {
    this.testPlan = testPlan;
  }

  public DataSetListDto visibilityArea(VisibilityAreaDto visibilityArea) {
    this.visibilityArea = visibilityArea;
    return this;
  }

  /**
   * Get visibilityArea
   * @return visibilityArea
  */
  @NotNull @Valid 
  @Schema(name = "visibilityArea", required = true)
  public VisibilityAreaDto getVisibilityArea() {
    return visibilityArea;
  }

  public void setVisibilityArea(VisibilityAreaDto visibilityArea) {
    this.visibilityArea = visibilityArea;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSetListDto dataSetList = (DataSetListDto) o;
    return Objects.equals(this.attributes, dataSetList.attributes) &&
        Objects.equals(this.createdBy, dataSetList.createdBy) &&
        Objects.equals(this.createdWhen, dataSetList.createdWhen) &&
        Objects.equals(this.dataSets, dataSetList.dataSets) &&
        Objects.equals(this.id, dataSetList.id) &&
        Objects.equals(this.labels, dataSetList.labels) &&
        Objects.equals(this.modifiedBy, dataSetList.modifiedBy) &&
        Objects.equals(this.modifiedWhen, dataSetList.modifiedWhen) &&
        Objects.equals(this.name, dataSetList.name) &&
        Objects.equals(this.testPlan, dataSetList.testPlan) &&
        Objects.equals(this.visibilityArea, dataSetList.visibilityArea);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributes, createdBy, createdWhen, dataSets, id, labels, modifiedBy, modifiedWhen, name, testPlan, visibilityArea);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSetListDto {\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdWhen: ").append(toIndentedString(createdWhen)).append("\n");
    sb.append("    dataSets: ").append(toIndentedString(dataSets)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    testPlan: ").append(toIndentedString(testPlan)).append("\n");
    sb.append("    visibilityArea: ").append(toIndentedString(visibilityArea)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

