package org.qubership.atp.datasets.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.datasets.dto.AttributeTypeDto;
import org.qubership.atp.datasets.dto.UiManParameterDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * UiManAttributeDto
 */

@JsonTypeName("UiManAttribute")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-19T14:15:27.292Z[Etc/UTC]")
public class UiManAttributeDto {

  @JsonProperty("attributes")
  @Valid
  private List<UiManAttributeDto> attributes = null;

  @JsonProperty("dataSetListReference")
  private UUID dataSetListReference;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("parameters")
  @Valid
  private List<UiManParameterDto> parameters = null;

  @JsonProperty("type")
  private AttributeTypeDto type;

  public UiManAttributeDto attributes(List<UiManAttributeDto> attributes) {
    this.attributes = attributes;
    return this;
  }

  public UiManAttributeDto addAttributesItem(UiManAttributeDto attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

  /**
   * Get attributes
   * @return attributes
  */
  @Valid 
  @Schema(name = "attributes", required = false)
  public List<UiManAttributeDto> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<UiManAttributeDto> attributes) {
    this.attributes = attributes;
  }

  public UiManAttributeDto dataSetListReference(UUID dataSetListReference) {
    this.dataSetListReference = dataSetListReference;
    return this;
  }

  /**
   * Get dataSetListReference
   * @return dataSetListReference
  */
  @Valid 
  @Schema(name = "dataSetListReference", required = false)
  public UUID getDataSetListReference() {
    return dataSetListReference;
  }

  public void setDataSetListReference(UUID dataSetListReference) {
    this.dataSetListReference = dataSetListReference;
  }

  public UiManAttributeDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public UiManAttributeDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public UiManAttributeDto parameters(List<UiManParameterDto> parameters) {
    this.parameters = parameters;
    return this;
  }

  public UiManAttributeDto addParametersItem(UiManParameterDto parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

  /**
   * Get parameters
   * @return parameters
  */
  @Valid 
  @Schema(name = "parameters", required = false)
  public List<UiManParameterDto> getParameters() {
    return parameters;
  }

  public void setParameters(List<UiManParameterDto> parameters) {
    this.parameters = parameters;
  }

  public UiManAttributeDto type(AttributeTypeDto type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @Valid 
  @Schema(name = "type", required = false)
  public AttributeTypeDto getType() {
    return type;
  }

  public void setType(AttributeTypeDto type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UiManAttributeDto uiManAttribute = (UiManAttributeDto) o;
    return Objects.equals(this.attributes, uiManAttribute.attributes) &&
        Objects.equals(this.dataSetListReference, uiManAttribute.dataSetListReference) &&
        Objects.equals(this.id, uiManAttribute.id) &&
        Objects.equals(this.name, uiManAttribute.name) &&
        Objects.equals(this.parameters, uiManAttribute.parameters) &&
        Objects.equals(this.type, uiManAttribute.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributes, dataSetListReference, id, name, parameters, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UiManAttributeDto {\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    dataSetListReference: ").append(toIndentedString(dataSetListReference)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

