/*
 *  Copyright 2024-2025 NetCracker Technology Corporation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.qubership.automation.itf.core.model.key;

import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;
import org.qubership.automation.itf.core.util.exception.KeyDefinitionException;

public class BySingleParamKeyDefinition extends AbstractStorable implements KeyDefinition {
    private static final long serialVersionUID = 20240812L;

    private String expression;

    public BySingleParamKeyDefinition(String expression) {
        this.expression = expression;
    }

    public BySingleParamKeyDefinition() {
    }

    public String getExpression() {
        return expression;
    }

    @Override
    public void setExpression(String expression) {
        this.expression = expression;
    }

    /**
     * TODO: Add JavaDoc.
     */
    public String defineKey(InstanceContext context) throws KeyDefinitionException {
        Object parameter = context.get(expression);
        if (parameter instanceof String) {
            return ((String) parameter).trim();
        } else {
            return parameter != null ? parameter.toString() : null;
        }
    }

    @Override
    public String toString() {
        return "BySingleParamKeyDefinition{paramName='" + expression + "'}";
    }
}
