/*
 *  Copyright 2024-2025 NetCracker Technology Corporation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.qubership.automation.itf.core.util.ei.deserialize;

import java.io.IOException;
import java.util.Set;

import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Sets;

public class SituationsSetDeserializer extends JsonDeserializer<Set<Situation>> {
    @Override
    public Set<Situation> deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        Set<Situation> situations = Sets.newHashSet();
        ArrayNode arrayNode = jsonParser.getCodec().readTree(jsonParser);
        for (JsonNode jsonNode : arrayNode) {
            Situation situation = new Situation();
            situation.setID(jsonNode.bigIntegerValue());
            situations.add(situation);
        }
        return situations;
    }
}
