/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.hibernate.ManagerFactory;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.util.exception.NoSuchManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ObjectManagerFactoryHB
implements ManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectManagerFactoryHB.class);
    private static final String ROOT = "ROOT";
    protected List<ObjectManager<? extends Storable>> objectManagersBeans;
    protected HashMap<Type, ObjectManager> objectManagers = Maps.newHashMapWithExpectedSize((int)9);

    public List<ObjectManager<? extends Storable>> getObjectManagersBeans() {
        return this.objectManagersBeans;
    }

    @Autowired
    public void setObjectManagersBeans(List<ObjectManager<? extends Storable>> objectManagersBeans) {
        this.objectManagersBeans = objectManagersBeans;
    }

    @Override
    public <U extends Storable> ObjectManager<U> getManager(Class<U> clazz) {
        return this.getManInner(clazz);
    }

    public <U extends Storable> ObjectManager<U> getManager(TypeToken<U> storable) {
        return this.getManInner(storable.getType());
    }

    @Override
    public void register(Class<? extends Storable> clazz, ObjectManager manager) {
        this.objectManagers.put(clazz, manager);
    }

    private <T extends Storable> ObjectManager<T> getManInner(Type storable) {
        ObjectManager<T> result = this.objectManagers.get(storable);
        if (result == null) {
            result = this.findManager(Lists.newArrayList((Object[])new Predicate[]{new ObjManTypesafeGarant(storable), new ObjManTypesafeGarant2(storable)}).iterator());
            this.objectManagers.put(storable, result);
        }
        return result;
    }

    @Nonnull
    private <T extends Storable> ObjectManager<T> findManager(@Nonnull Iterator<Predicate<ObjectManager>> typesafeGarants) {
        Set candidates = null;
        Predicate<ObjectManager> typesafeGarant = null;
        while (CollectionUtils.isEmpty(candidates) && Objects.requireNonNull(typesafeGarants).hasNext()) {
            typesafeGarant = typesafeGarants.next();
            candidates = this.objectManagersBeans.stream().filter(typesafeGarant).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEmpty(candidates)) {
            throw new NoSuchManagerException(String.format("Object manager '%s' not found. Available managers: %s", typesafeGarant, this.objectManagersBeans));
        }
        if (candidates.size() > 1) {
            throw new NoSuchManagerException(String.format("Got multiple candidates for '%s'. Candidates are: %s", typesafeGarant, candidates));
        }
        ObjectManager found = (ObjectManager)candidates.iterator().next();
        try {
            return found;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Typesafe garant '%s' assumes that '%s' has proper type. But it has not", typesafeGarant, found), e);
        }
    }

    private static class ObjManTypesafeGarant2
    implements Predicate<ObjectManager> {
        private final Type storableType;

        private ObjManTypesafeGarant2(Type type) {
            this.storableType = type;
        }

        @Override
        public boolean test(ObjectManager input) {
            return TypeToken.of(input.getClass()).resolveType(ObjectManager.class.getTypeParameters()[0]).isSupertypeOf(this.storableType);
        }

        public String toString() {
            return String.format("%s<? extends %s>", ObjectManager.class.getSimpleName(), this.storableType);
        }
    }

    private static class ObjManTypesafeGarant
    implements Predicate<ObjectManager> {
        private final Type storableType;

        private ObjManTypesafeGarant(Type type) {
            this.storableType = type;
        }

        @Override
        public boolean test(ObjectManager input) {
            Type managersGenericType = TypeToken.of(input.getClass()).resolveType(ObjectManager.class.getTypeParameters()[0]).getType();
            return this.storableType.equals(managersGenericType);
        }

        public String toString() {
            return String.format("%s<%s>", ObjectManager.class.getSimpleName(), this.storableType);
        }
    }
}

