/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.EventTriggerManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.EventTriggerObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.OperationEventTriggerRepository;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperationEventTriggerObjectManager
extends EventTriggerObjectManager<OperationEventTrigger>
implements EventTriggerManager<OperationEventTrigger>,
SearchByProjectIdManager<OperationEventTrigger> {
    @Autowired
    public OperationEventTriggerObjectManager(OperationEventTriggerRepository repository) {
        super(OperationEventTrigger.class, repository);
    }

    @Override
    public List<OperationEventTrigger> getAllActive(@Nonnull Operation operation) {
        return ((OperationEventTriggerRepository)this.repository).getActiveTriggersByOperationNative(IdConverter.toBigInt(operation.getID()));
    }

    public List<BigInteger> getActiveTriggersBySituationIdsNative(List<BigInteger> situationIds) {
        return ((OperationEventTriggerRepository)this.repository).getActiveTriggersBySituationIdsNative(situationIds);
    }

    @Override
    public List<OperationEventTrigger> getActiveByProject(@NotNull BigInteger projectId) {
        return ((OperationEventTriggerRepository)this.repository).getActiveTriggersByProject(projectId);
    }

    @Override
    public Collection<OperationEventTrigger> getByProjectId(BigInteger projectId) {
        return ((OperationEventTriggerRepository)this.repository).findByProject(projectId);
    }

    public OperationEventTrigger getByIdOnly(BigInteger id) {
        return ((OperationEventTriggerRepository)this.repository).findByIdOnly(id);
    }
}

