/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.executor;

import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.tuple.Triple;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.ParsingRuleRepository;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.util.constants.Match;
import org.qubership.automation.itf.core.util.helper.PropertyHelper;
import org.qubership.automation.itf.core.util.parser.ParsingRuleType;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParsingRuleObjectManager<K extends ParsingRuleProvider, T extends ParsingRule<K>>
extends AbstractObjectManager<T, T>
implements SearchByProjectIdManager<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsingRuleObjectManager.class);

    public ParsingRuleObjectManager(Class<T> clazz, ParsingRuleRepository<K, T> repository) {
        super(clazz, repository);
    }

    @Override
    public T create(Storable parent) {
        try {
            ParsingRule parsingRule = (ParsingRule)this.myType.getConstructor(Storable.class).newInstance(parent);
            if (parent instanceof ParsingRuleProvider) {
                ((ParsingRuleProvider)parent).addParsingRule(parsingRule);
            }
            return (T)((ParsingRule)this.repository.save(parsingRule));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Error while parsing rule creation: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public T create(Storable parent, String type, Map parameters) {
        if (!(parent instanceof ParsingRuleProvider)) {
            throw new IllegalArgumentException(String.format("Can't add parsing rule to '%s',  because object is not parsing rule provider!", parent));
        }
        ParsingRule parsingRule = (ParsingRule)super.create(parent, type, parameters);
        parsingRule.setParsingType(ParsingRuleType.XPATH);
        parsingRule.setExpression(".");
        return (T)parsingRule;
    }

    @Override
    public Collection<T> getByProjectId(BigInteger projectId) {
        return ((ParsingRuleRepository)this.repository).findByProjectId(projectId);
    }

    @Override
    public Collection<T> getByProperties(BigInteger projectId, Triple<String, Match, ?> ... properties) {
        LinkedList toReturn = new LinkedList<T>(){};
        Collection<T> all = this.getByProjectId(projectId);
        for (ParsingRule rule : all) {
            if (!PropertyHelper.meetsAllProperties(rule, properties)) continue;
            toReturn.add(rule);
        }
        return toReturn;
    }
}

