/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.reports;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.MonitoringManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.reports.TcContextBriefInfoObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.reports.InstanceContextRepository;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContextBriefInfo;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InstanceContextObjectManager
extends AbstractObjectManager<InstanceContext, InstanceContext>
implements MonitoringManager {
    private final InstanceContextRepository instanceContextRepository;

    @Autowired
    public InstanceContextObjectManager(InstanceContextRepository repository) {
        super(InstanceContext.class, repository);
        this.instanceContextRepository = repository;
    }

    @Override
    public void protectedOnRemove(InstanceContext object) {
    }

    @Override
    public HashMap<String, Object> getStepInstanceError(String stepInstanceId, Integer partNum) {
        List<Object[]> errors = this.instanceContextRepository.stepInstanceError(IdConverter.toBigInt(stepInstanceId), partNum);
        HashMap<String, Object> errorInfo = new HashMap<String, Object>();
        if (errors != null && !errors.isEmpty() && errors.get(0).length == 2) {
            errorInfo.put("errorName", errors.get(0)[0]);
            errorInfo.put("errorMessage", errors.get(0)[1]);
        }
        return errorInfo;
    }

    @Override
    public HashMap<String, Object> getSpMessageParameters(Object spcontextId, Integer partNum) {
        List<Object[]> queryResults = this.instanceContextRepository.getSpMessageParameters(IdConverter.toBigInt(spcontextId), partNum);
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        for (Object[] elem : queryResults) {
            if (elem == null || elem.length != 2) continue;
            messageParameters.put(elem[0].toString(), elem[1]);
        }
        return messageParameters;
    }

    @Override
    public List<Object[]> allTcContextInstancesErrors(String tcId, Integer partNum) {
        return this.instanceContextRepository.allTcContextInstancesErrors(IdConverter.toBigInt(tcId), partNum);
    }

    @Override
    public HashMap<String, Object> getStepInstanceMessageIds(String stepInstanceId, Integer partNum) {
        List<Object[]> ids = this.instanceContextRepository.getMessageIds(IdConverter.toBigInt(stepInstanceId), partNum);
        HashMap<String, Object> idsMap = new HashMap<String, Object>();
        if (ids != null && !ids.isEmpty() && ids.get(0).length == 4) {
            idsMap.put("spContextId", ids.get(0)[0]);
            idsMap.put("incomingMessageId", ids.get(0)[1]);
            idsMap.put("outgoingMessageId", ids.get(0)[2]);
            idsMap.put("stepContext", ids.get(0)[3]);
        }
        return idsMap;
    }

    @Override
    public String getMessageText(Object messageId, Integer partNum) {
        return this.instanceContextRepository.getMessageText(IdConverter.toBigInt(messageId), partNum);
    }

    @Override
    public HashMap<String, Object> getMessageHeaders(Object messageId, Integer partNum) {
        return this.fillMap(this.instanceContextRepository.getMessageHeaders(IdConverter.toBigInt(messageId), partNum));
    }

    @Override
    public HashMap<String, Object> getMessageConnectionProperties(Object messageId, Integer partNum) {
        return this.fillMap(this.instanceContextRepository.getMessageConnectionProperties(IdConverter.toBigInt(messageId), partNum));
    }

    private HashMap<String, Object> fillMap(List<Object[]> list) {
        if (list == null || list.isEmpty()) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object[] obj : list) {
            map.put((String)obj[0], obj[1]);
        }
        return map;
    }

    @Override
    public List<Object[]> getTreeMessagesFromTcContext(String id, Integer partNum) {
        if (!StringUtils.isBlank((CharSequence)id)) {
            return this.instanceContextRepository.getTcContextTree(IdConverter.toBigInt(id), partNum);
        }
        return Collections.emptyList();
    }

    @Override
    public TcContextBriefInfo getTcContextInformation(String tcContextId, Integer partNum) {
        TcContextBriefInfo tcContextBriefInfo;
        TcContextBriefInfoObjectManager objectManager = CoreObjectManager.getInstance().getSpecialManager(TcContextBriefInfo.class, TcContextBriefInfoObjectManager.class);
        TcContextBriefInfo tcContextBriefInfo2 = tcContextBriefInfo = partNum == null ? (TcContextBriefInfo)objectManager.getById(IdConverter.toBigInt(tcContextId)) : objectManager.getByIDAndPartNum(IdConverter.toBigInt(tcContextId), partNum);
        if (tcContextBriefInfo == null) {
            return null;
        }
        if (Objects.isNull(tcContextBriefInfo.getInitiator())) {
            return tcContextBriefInfo;
        }
        List<Object[]> initiatorInfo = this.instanceContextRepository.getTcContextInitiatorInfo(IdConverter.toBigInt(tcContextBriefInfo.getInitiator()), tcContextBriefInfo.getPartNum());
        if (!Objects.isNull(initiatorInfo) && !initiatorInfo.isEmpty()) {
            tcContextBriefInfo.setIniname((String)initiatorInfo.get(0)[0]);
            tcContextBriefInfo.setInitiatortype((String)initiatorInfo.get(0)[1]);
            tcContextBriefInfo.setSituationId((BigInteger)initiatorInfo.get(0)[2]);
            tcContextBriefInfo.setChainId((BigInteger)initiatorInfo.get(0)[3]);
            tcContextBriefInfo.setExecutiondata((String)initiatorInfo.get(0)[4]);
            tcContextBriefInfo.setOperationName((String)initiatorInfo.get(0)[5]);
            tcContextBriefInfo.setSystemName((String)initiatorInfo.get(0)[6]);
            tcContextBriefInfo.setSystemId((BigInteger)initiatorInfo.get(0)[7]);
        }
        return tcContextBriefInfo;
    }

    @Override
    public List<Object[]> getTcContextInfo(String tcContextId) {
        return this.instanceContextRepository.getTcContextInfo(IdConverter.toBigInt(tcContextId));
    }

    @Override
    public String getContextVariables(String tcContextId, Integer partNum) {
        return this.instanceContextRepository.getContextVariables(IdConverter.toBigInt(tcContextId), partNum);
    }

    @Override
    public String getContextVariables(String tcContextId) {
        return this.instanceContextRepository.getContextVariables(IdConverter.toBigInt(tcContextId));
    }

    @Override
    public HashMap<String, String> getTcContextReportLinks(String tcContextId, Integer partNum) {
        List<Object[]> links = this.instanceContextRepository.getTcContextReportLinks(IdConverter.toBigInt(tcContextId), partNum);
        HashMap<String, String> linksMap = new HashMap<String, String>();
        for (Object[] link : links) {
            if (link == null || link.length != 2) continue;
            linksMap.put(link[0].toString(), link[1].toString());
        }
        return linksMap;
    }

    @Override
    public Set<String> getTcContextBindingKeys(String tcContextId, Integer partNum) {
        return this.instanceContextRepository.getTcContextBindingKeys(IdConverter.toBigInt(tcContextId), partNum);
    }

    @Override
    public Set<String> getTcContextBindingKeys(String tcContextId) {
        return this.instanceContextRepository.getTcContextBindingKeys(IdConverter.toBigInt(tcContextId));
    }

    @Override
    public String getValidationResults(Object spContextId, Integer partNum) {
        return this.instanceContextRepository.getValidationResults(IdConverter.toBigInt(spContextId), partNum);
    }

    @Override
    public HashMap<String, String> getTcContextStepsSituations(String tcContextId, Integer partNum) {
        List<Object[]> situations = this.instanceContextRepository.getTcContextStepsSituations(IdConverter.toBigInt(tcContextId), partNum);
        HashMap<String, String> situationsMap = new HashMap<String, String>();
        for (Object[] situation : situations) {
            if (situation == null || situation.length != 2) continue;
            situationsMap.put(situation[0].toString(), situation[1].toString());
        }
        return situationsMap;
    }
}

