/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.managers.reports;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.AbstractObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.repositories.reports.TcContextBriefInfoRepository;
import org.qubership.automation.itf.core.model.jpa.context.QTcContextBriefInfo;
import org.qubership.automation.itf.core.model.jpa.context.TcContextBriefInfo;
import org.qubership.automation.itf.core.util.constants.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class TcContextBriefInfoObjectManager
extends AbstractObjectManager<TcContextBriefInfo, TcContextBriefInfo>
implements SearchByProjectIdManager<TcContextBriefInfo> {
    private static final Sort SORT_BY_START_TIME_DESC = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "startTime")});
    private static TcContextBriefInfoRepository tcContextBriefInfoRepository;

    @Autowired
    protected TcContextBriefInfoObjectManager(TcContextBriefInfoRepository repository) {
        super(TcContextBriefInfo.class, repository);
        tcContextBriefInfoRepository = repository;
    }

    @PostConstruct
    protected void init() {
    }

    public static Page<TcContextBriefInfo> getPage(int pageSize, int pageIndex, BigInteger projectId) {
        PageRequest pageable = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)SORT_BY_START_TIME_DESC);
        BooleanExpression predicate = null;
        QTcContextBriefInfo contextInfo = QTcContextBriefInfo.tcContextBriefInfo;
        predicate = TcContextBriefInfoObjectManager.addBigIntegerExpression(predicate, contextInfo.projectId, projectId);
        return tcContextBriefInfoRepository.findAll((Predicate)predicate, (Pageable)pageable);
    }

    private static BooleanExpression combineExpressions(BooleanExpression predicate, BooleanExpression expr) {
        if (predicate == null) {
            return expr;
        }
        return predicate.and((Predicate)expr);
    }

    private static BooleanExpression addStringExpression(BooleanExpression predicate, StringPath stringPath, String str) {
        String s;
        if (StringUtils.isNotBlank((CharSequence)str) && !(s = str.trim()).isEmpty()) {
            BooleanExpression expr = stringPath.containsIgnoreCase(s);
            return TcContextBriefInfoObjectManager.combineExpressions(predicate, expr);
        }
        return predicate;
    }

    private static BooleanExpression addBigIntegerExpression(BooleanExpression predicate, NumberPath<BigInteger> object, BigInteger value) {
        if (value != null) {
            BooleanExpression expr = object.eq((Object)value);
            return TcContextBriefInfoObjectManager.combineExpressions(predicate, expr);
        }
        return predicate;
    }

    private static BooleanExpression addDateExpression(BooleanExpression predicate, DateTimePath<Date> datePath, Date dat, String condition) {
        if (dat != null) {
            BooleanExpression expr;
            switch (condition) {
                case "more": 
                case ">": {
                    expr = datePath.goe((Comparable)dat);
                    break;
                }
                case "less": 
                case "<": {
                    expr = datePath.loe((Comparable)dat);
                    break;
                }
                default: {
                    Date nextDay = new Date(dat.getTime() + 86400000L);
                    expr = datePath.goe((Comparable)dat).and((Predicate)datePath.lt((Comparable)nextDay));
                }
            }
            if (expr != null) {
                return TcContextBriefInfoObjectManager.combineExpressions(predicate, expr);
            }
        }
        return predicate;
    }

    private static BooleanExpression addDurationExpression(BooleanExpression predicate, NumberPath<Long> durationPath, Long duration, String condition) {
        if (duration != null) {
            BooleanExpression expr = null;
            switch (condition) {
                case "more": 
                case ">": {
                    expr = durationPath.goe((Number)duration);
                    break;
                }
                case "less": 
                case "<": {
                    expr = durationPath.loe((Number)duration);
                    break;
                }
            }
            if (expr != null) {
                return TcContextBriefInfoObjectManager.combineExpressions(predicate, expr);
            }
        }
        return predicate;
    }

    private static BooleanExpression makePredicate(String name, String initiator, String status, String environment, Date stDate, String startDateCondition, Date finDate, String finishDateCondition, Long duration, String durationCondition, String client, boolean notRunningOnly, BigInteger projectId) {
        String s;
        QTcContextBriefInfo contextInfo = QTcContextBriefInfo.tcContextBriefInfo;
        BooleanExpression predicate = null;
        predicate = TcContextBriefInfoObjectManager.addStringExpression(predicate, contextInfo.name, name);
        predicate = TcContextBriefInfoObjectManager.addStringExpression(predicate, contextInfo.ininame, initiator);
        predicate = TcContextBriefInfoObjectManager.addStringExpression(predicate, contextInfo.envname, environment);
        predicate = TcContextBriefInfoObjectManager.addStringExpression(predicate, contextInfo.client, client);
        predicate = TcContextBriefInfoObjectManager.addDateExpression(predicate, contextInfo.startTime, stDate, startDateCondition);
        predicate = TcContextBriefInfoObjectManager.addDateExpression(predicate, contextInfo.endTime, finDate, finishDateCondition);
        predicate = TcContextBriefInfoObjectManager.addDurationExpression(predicate, contextInfo.duration, duration, durationCondition);
        predicate = TcContextBriefInfoObjectManager.addBigIntegerExpression(predicate, contextInfo.projectId, projectId);
        if (!StringUtils.isBlank((CharSequence)status) && !(s = status.trim().replace(' ', '_')).isEmpty()) {
            BooleanExpression statusExpr = contextInfo.status.stringValue().containsIgnoreCase(s);
            predicate = TcContextBriefInfoObjectManager.combineExpressions(predicate, statusExpr);
        }
        if (notRunningOnly) {
            BooleanExpression notInProgressExpr = contextInfo.status.ne((Object)Status.IN_PROGRESS);
            predicate = TcContextBriefInfoObjectManager.combineExpressions(predicate, notInProgressExpr);
        }
        return predicate;
    }

    public static Page<TcContextBriefInfo> getPageByFilter(int pageSize, int pageIndex, boolean search, String name, String initiator, String status, String environment, Date stDate, String startDateCondition, Date finDate, String finishDateCondition, Long duration, String durationCondition, String client, String sortProperty, boolean sortOrder, BigInteger projectId) {
        String sortBy;
        if (StringUtils.isNotEmpty((CharSequence)sortProperty)) {
            switch (sortProperty) {
                case "initiator": {
                    sortBy = "ininame";
                    break;
                }
                case "environment": {
                    sortBy = "envname";
                    break;
                }
                default: {
                    sortBy = sortProperty;
                    break;
                }
            }
        } else {
            sortBy = "ID";
        }
        PageRequest pageable = PageRequest.of((int)(pageIndex == -1 ? 0 : pageIndex), (int)pageSize, (Sort)Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(sortOrder ? Sort.Direction.DESC : Sort.Direction.ASC, sortBy)}));
        BooleanExpression predicate = TcContextBriefInfoObjectManager.makePredicate(name, initiator, status, environment, stDate, startDateCondition, finDate, finishDateCondition, duration, durationCondition, client, false, projectId);
        if (predicate != null) {
            return tcContextBriefInfoRepository.findAll((Predicate)predicate, (Pageable)pageable);
        }
        return tcContextBriefInfoRepository.findAll((Pageable)pageable);
    }

    public static Iterable<TcContextBriefInfo> getReportByFilter(String name, String initiator, String status, String environment, Date stDate, String startDateCondition, Date finDate, String finishDateCondition, Long duration, String durationCondition, String client, String sortProperty, boolean sortOrder, BigInteger projectId) {
        BooleanExpression predicate;
        String sortBy;
        if (StringUtils.isNotEmpty((CharSequence)sortProperty)) {
            switch (sortProperty) {
                case "initiator": {
                    sortBy = "ininame";
                    break;
                }
                case "environment": {
                    sortBy = "envname";
                    break;
                }
                default: {
                    sortBy = sortProperty;
                    break;
                }
            }
        } else {
            sortBy = "ID";
        }
        if ((predicate = TcContextBriefInfoObjectManager.makePredicate(name, initiator, status, environment, stDate, startDateCondition, finDate, finishDateCondition, duration, durationCondition, client, false, projectId)) != null) {
            return tcContextBriefInfoRepository.findAll((Predicate)predicate, Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(sortOrder ? Sort.Direction.DESC : Sort.Direction.ASC, sortBy)}));
        }
        return tcContextBriefInfoRepository.findAll(Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(sortOrder ? Sort.Direction.DESC : Sort.Direction.ASC, sortBy)}));
    }

    public static Iterable<TcContextBriefInfo> simpleSearch(String initiator, String status, String environment, Date minStartDate, Date maxStartDate) {
        String s;
        QTcContextBriefInfo contextInfo = QTcContextBriefInfo.tcContextBriefInfo;
        BooleanExpression predicate = null;
        predicate = TcContextBriefInfoObjectManager.addStringExpression(predicate, contextInfo.ininame, initiator);
        predicate = TcContextBriefInfoObjectManager.addStringExpression(predicate, contextInfo.envname, environment);
        predicate = TcContextBriefInfoObjectManager.addDateExpression(predicate, contextInfo.endTime, minStartDate, "more");
        predicate = TcContextBriefInfoObjectManager.addDateExpression(predicate, contextInfo.startTime, maxStartDate, "less");
        if (!StringUtils.isBlank((CharSequence)status) && !(s = status.trim().replace(' ', '_')).isEmpty()) {
            BooleanExpression statusExpr = contextInfo.status.stringValue().containsIgnoreCase(s);
            predicate = TcContextBriefInfoObjectManager.combineExpressions(predicate, statusExpr);
        }
        return tcContextBriefInfoRepository.findAll((Predicate)predicate);
    }

    public static Iterable<TcContextBriefInfo> findByFilter(String name, String initiator, String status, String environment, Date stDate, String startDateCondition, Date finDate, String finishDateCondition, Long duration, String durationCondition, String client, BigInteger projectId) {
        BooleanExpression predicate = TcContextBriefInfoObjectManager.makePredicate(name, initiator, status, environment, stDate, startDateCondition, finDate, finishDateCondition, duration, durationCondition, client, true, projectId);
        if (predicate != null) {
            return tcContextBriefInfoRepository.findAll((Predicate)predicate);
        }
        return new ArrayList<TcContextBriefInfo>();
    }

    public static Iterable<TcContextBriefInfo> findNotRunning() {
        QTcContextBriefInfo contextInfo = QTcContextBriefInfo.tcContextBriefInfo;
        BooleanExpression notInProgressExpr = contextInfo.status.ne((Object)Status.IN_PROGRESS);
        return tcContextBriefInfoRepository.findAll((Predicate)notInProgressExpr);
    }

    public static Iterable<TcContextBriefInfo> findAll() {
        return tcContextBriefInfoRepository.findAll();
    }

    @Override
    public Collection<TcContextBriefInfo> getByProjectId(BigInteger projectId) {
        return tcContextBriefInfoRepository.findByProjectId(projectId);
    }

    public TcContextBriefInfo getByIDAndPartNum(BigInteger id, Integer partNum) {
        return tcContextBriefInfoRepository.findByIDAndPartNum(id, partNum);
    }

    public static int getCurrentPartitionNumber() {
        return tcContextBriefInfoRepository.getCurrentPartitionNumber();
    }
}

