/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import javax.persistence.QueryHint;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.EventTriggerRepository;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
@JaversSpringDataAuditable
public interface SituationEventTriggerRepository
extends EventTriggerRepository<SituationEventTrigger> {
    @Modifying
    @Query(value="update SituationEventTrigger t set t.situation = null where t.situation = :situation")
    public void onDeleteSituation(@Param(value="situation") Situation var1);

    @Query(value="select trigger from SituationEventTrigger trigger where trigger.situation = :situation")
    public Iterable<SituationEventTrigger> getTriggersBySituation(@Param(value="situation") Situation var1);

    @Query(value="select trigger from SituationEventTrigger trigger inner join Situation as situation on situation = trigger.parent inner join Operation as operation on operation = situation.parent where operation.projectId = :projectId")
    public Collection<SituationEventTrigger> findByProject(@Param(value="projectId") BigInteger var1);

    @Query(value="select trg.* from mb_triggers trg inner join mb_situation sit on sit.id = trg.set_parent_id inner join mb_operations op on op.id = sit.parent_id where trg.parent_type = 'situation' and trg.state = 'ACTIVE' and op.project_id = :projectId", nativeQuery=true)
    public List<SituationEventTrigger> getActiveTriggersByProject(@Param(value="projectId") BigInteger var1);

    @Query(value="select trg.* from mb_triggers trg \ninner join mb_situation sit on sit.id = trg.set_parent_id \ninner join mb_operations op on op.id = sit.parent_id \nwhere trg.parent_type = 'situation' and op.parent_id = :systemId", nativeQuery=true)
    public List<SituationEventTrigger> getTriggersBySystemId(@Param(value="systemId") BigInteger var1);

    @Query(value="select trg.id, trg.state from mb_triggers trg \ninner join mb_situation sit on sit.id = trg.set_parent_id \ninner join mb_operations op on op.id = sit.parent_id \nwhere op.parent_id = :systemId", nativeQuery=true)
    public List<Object[]> getTriggersBriefInfoBySystemId(@Param(value="systemId") BigInteger var1);

    @Query(value="select trigger from SituationEventTrigger as trigger where id = :id")
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="situationEventTriggerCache")})
    public SituationEventTrigger findByIdOnly(@Param(value="id") BigInteger var1);
}

