/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.FastStubsCandidate;
import org.qubership.automation.itf.core.model.IdNamePair;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
@JaversSpringDataAuditable
public interface SituationRepository
extends StorableRepository<Situation> {
    @Query(value="select count(*) from mb_situation where bv_tcid = :bvCaseId", nativeQuery=true)
    public int countBvCaseUsages(@Param(value="bvCaseId") String var1);

    @Query(value="select distinct msl.labels from mb_situation as ms inner join mb_operations as mo on mo.id = ms.parent_id inner join mb_situation_labels as msl on msl.id = ms.id where mo.project_id = :projectId ", nativeQuery=true)
    public Set<String> getAllLabels(@Param(value="projectId") BigInteger var1);

    @Query(value="select new org.qubership.automation.itf.core.model.IdNamePair(situation.id, situation.name) from Situation as situation inner join Operation as operation on operation = situation.parent where operation.projectId = :projectId")
    public Collection<IdNamePair> findAllByProjectIdOfNameAndId(@Param(value="projectId") BigInteger var1);

    @Query(value="select situation from Situation as situation inner join Operation as operation on operation = situation.parent where operation.projectId = :projectId")
    public Collection<Situation> findAllByProjectId(@Param(value="projectId") BigInteger var1);

    @Query(value="select situation from Situation as situation inner join Operation as operation on operation = situation.parent where lower(situation.name) like concat('%', lower(:name), '%')  and operation.projectId = :projectId")
    public Collection<Situation> findByPieceOfNameAndProject(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select situation from Situation as situation inner join Operation as operation on operation = situation.parent where lower(situation.name) = lower(:name)and operation.projectId = :projectId")
    public List<Situation> findByNameAndProjectId(@Param(value="name") String var1, @Param(value="projectId") BigInteger var2);

    @Query(value="select sit.id, sit.parent_id as operation_id, sit.bv_tcid, sit.validate_incoming,\nst.\"name\" as situation_name,\nop.\"name\" as operation_name,\nop.parent_id as system_id,\nsys.\"name\" as system_name\nfrom mb_situation sit\ninner join mb_step_container st on sit.id=st.id\ninner join mb_operations op on sit.parent_id=op.id\ninner join mb_systems as sys on sys.id = op.parent_id\nwhere sit.bv_tcid is not null \nand sit.bv_tcid != '' \nand sys.project_id = :projectId", nativeQuery=true)
    public List<Object[]> getSituationsWithBvLinks(@Param(value="projectId") BigInteger var1);

    @Query(value="with\ncommon as (select\nsys.id as systemId,\noperation.id as operationId,\noperation.\"name\" as operationName,\nsituation.id as situationId,\nstep.\"name\" as situationName,\ncase when transport.type_name = 'org.qubership.automation.itf.transport.rest.inbound.RESTInboundTransport' then 'REST'  when transport.type_name = 'org.qubership.automation.itf.transport.soap.http.inbound.SOAPOverHTTPInboundTransport' then 'SOAP' else 'UNKNOWN' end as transportType, \ntransport.params\\:\\:json#>>'{endpoint}' as endpoint,\ncase when situation.validate_incoming is not null and situation.validate_incoming != 'NO' then 1 else 0 end as bv_validation,\ncount(case when templ.\"text\" ~ '.*(#get_config|#get_ds_file|#load_part|#next_index|#set_config|#set_userdata).*' then 1 end) over (partition by situation.id) as template_script,\ncount(case when situation.pre_script ~ '.*(#get_config|#get_ds_file|#load_part|#next_index|#set_config|#set_userdata).*' then 1 end) over (partition by situation.id) as pre_script,\ncount(case when situation.post_script ~ '.*(#get_config|#get_ds_file|#load_part|#next_index|#set_config|#set_userdata).*' then 1 end) over (partition by situation.id) as post_script,\ncount(case when situation.pre_validation_script ~ '.*(#get_config|#get_ds_file|#load_part|#next_index|#set_config|#set_userdata).*' then 1 end) over (partition by situation.id) as prevalid_script,\ncase when triggers.id is not null then 1 else 0 end as start_finish_triggers\nfrom mb_situation situation\nleft outer join mb_triggers triggers on (triggers.situation_id = situation.id),\nmb_operations operation,\nmb_systems sys,\nmb_configuration transport,\nmb_step_container step,\nmb_projects project,\nmb_templates templ,\nmb_steps steps\nwhere operation.project_id = project.id\nand project.\"uuid\" = :projectUuid \nand situation.parent_id = operation.id\nand step.id = situation.id\nand operation.parent_id = sys.id\nand operation.transport_id = transport.id\nand transport.\"type\" = 'transport'\nand transport.type_name in ('org.qubership.automation.itf.transport.rest.inbound.RESTInboundTransport','org.qubership.automation.itf.transport.soap.http.inbound.SOAPOverHTTPInboundTransport')\nand steps.parent_id = situation.id and templ.id = coalesce(steps.sys_template_id, steps.op_template_id)\nand (transport.params\\:\\:json#>>'{isStub}' = 'Yes' or transport.params\\:\\:json#>>'{isStub}' is null)\nand operation.id in ( :operationIds )\n),\ncommon_with_details as (\nselect\ncommon_info.systemId,\ncommon_info.operationId,\ncommon_info.operationName,\ncommon_info.situationId,\ncommon_info.situationName,\ncommon_info.transportType,\ncommon_info.endpoint,\n(common_info.bv_validation*1 + common_info.template_script*2 + common_info.pre_script*4 + common_info.post_script*8 + common_info.prevalid_script*16 + common_info.start_finish_triggers*32) as details\nfrom common common_info\n)\nselect d.* from common_with_details d", nativeQuery=true)
    public Optional<List<FastStubsCandidate>> getFastStubsCandidates(@Param(value="projectUuid") UUID var1, @Param(value="operationIds") List<BigInteger> var2);
}

