/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.hibernate.spring.repositories.executor;

import java.math.BigInteger;
import java.util.Collection;
import org.qubership.automation.itf.core.hibernate.spring.repositories.base.StorableRepository;
import org.qubership.automation.itf.core.model.jpa.environment.TriggerConfiguration;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface TriggerConfigurationRepository
extends StorableRepository<TriggerConfiguration>,
QuerydslPredicateExecutor<TriggerConfiguration> {
    @Modifying
    @Query(value="delete from InboundTransportConfiguration i where i.referencedConfiguration = :configuration")
    public void onDeleteTrigger(@Param(value="configuration") TriggerConfiguration var1);

    @Query(value="select ms.project_id from mb_configuration mc, mb_servers ms where mc.id = (select parent_conf_id from mb_configuration mc2 where mc2.id = :triggerConfigurationId) and ms.id = mc.parent_in_server_id", nativeQuery=true)
    public BigInteger getProjectId(@Param(value="triggerConfigurationId") BigInteger var1);

    @Query(value="select trigger.* from mb_configuration trigger where \"type\"= 'trigger' and trigger_state = 'ACTIVE' and parent_conf_id in (select mc.id from mb_configuration mc where mc.parent_in_server_id in (select ms.id from mb_servers ms where ms.project_id = :projectId))", nativeQuery=true)
    public Collection<TriggerConfiguration> getAllActiveTriggersByProjectId(@Param(value="projectId") BigInteger var1);

    @Query(value="select trigger.* from mb_configuration trigger where \"type\"= 'trigger' and (trigger_state = 'ACTIVE' or trigger_state = 'ERROR') and parent_conf_id in (select mc.id from mb_configuration mc where mc.parent_in_server_id in (select ms.id from mb_servers ms where ms.project_id = :projectId))", nativeQuery=true)
    public Collection<TriggerConfiguration> getAllActiveAndErrorTriggersByProjectId(@Param(value="projectId") BigInteger var1);

    @Query(value="select trigger.* from mb_configuration trigger where \"type\"= 'trigger' and parent_conf_id in (select mc.id from mb_configuration mc where mc.parent_in_server_id in (select ms.id from mb_servers ms where ms.project_id = :projectId))", nativeQuery=true)
    public Collection<TriggerConfiguration> getAllTriggersByProjectId(@Param(value="projectId") BigInteger var1);
}

